<?php
namespace Tenweb_Builder;
class DomainConnect {

    public $from_demo = FALSE;
    public $twbb_domain_name_suggestion = FALSE;

    public function __construct( $from_demo, $twbb_domain_name_suggestion ) {
        $this->from_demo = $from_demo;
        $this->twbb_domain_name_suggestion = $twbb_domain_name_suggestion;
        $this->html_template();
        if( $this->twbb_domain_name_suggestion ) {
            $this->register_script_style();
        }
    }

    private function register_script_style() {
        wp_enqueue_style(TWBB_PREFIX . '-domain-connect-style', TWBB_URL . '/includes/PreviewUpgrade/assets/style/domain_connect.css', array(), TWBB_VERSION);
        wp_enqueue_script(TWBB_PREFIX . '-domain-connect-script', TWBB_URL . '/includes/PreviewUpgrade/assets/script/domain_connect.js', ['jquery'], TWBB_VERSION);
    }

    private function html_template() {
        /* Domain top bar template */
        $domain_id = get_site_option('tenweb_domain_id');
        $dashboard_url = TENWEB_DASHBOARD . '/websites/'. $domain_id . '/domains/?domain=';
        if( !$this->from_demo ) {
            $this->twbb_domain_name_suggestion = get_option('twbb_domain_name_suggestion');
        }

        $is_custom_domain = true;
        $domain_name = '';
        $connect_title = esc_html__( 'Get free custom domain', 'tenweb-builder' );
        $description = '';

        if( $this->twbb_domain_name_suggestion ) {
            $twbb_domain_name_suggestion = json_decode($this->twbb_domain_name_suggestion, 1);
            $want_domain = isset($twbb_domain_name_suggestion['want_domain']) ? intval($twbb_domain_name_suggestion['want_domain']) : 0;
            if( !$want_domain ) {
                return;
            }
            if( !empty($twbb_domain_name_suggestion['domain_name']) ) {
                $domain_name = esc_html($twbb_domain_name_suggestion['domain_name']);
                $dashboard_url .= $domain_name;
                $connect_title = esc_html__( 'Connect your domain', 'tenweb-builder' );
                $description = esc_html__( 'is avalable.', 'tenweb-builder' );
                $is_custom_domain = false;
            }
        } else {
            return;
        }


        if( $domain_id ) {
            $dashboard_url .= '&domain_id='.intval($domain_id);
        }


        ?>
        <script type="text/template" id="twbb-topbar-domain-template">
            <div class='twbb-topbar-domain'>
                <img class='twbb-topbar-domain-icon' src="<?php echo TWBB_URL ?>/includes/PreviewUpgrade/assets/images/domain_white.svg">
                <?php
                if ( $domain_name !== '' ) {
                    ?>
                    <span class="twbb-topbar-subdomain-title"><?php echo esc_html( $domain_name ); ?></span>
                    <?php
                }
                if ( !$is_custom_domain ) {
                    ?>
                    <span class="twbb-topbar-subdomain-descr"><?php echo esc_html( $description ); ?></span>
                    <?php
                }
                if ( $this->from_demo ) { ?>
                    <span class="twbb-topbar-domain-connect twbb-topbar-domain-connect-demo"><?php echo esc_html( $connect_title ); ?></span>
                <?php
                } else {
                ?>
                    <a class="twbb-topbar-domain-connect" target="_blank" href="<?php echo esc_url($dashboard_url);?>"><?php echo esc_html( $connect_title ); ?></a>
                <?php } ?>
            </div>
        </script>
        <?php
    }
}