<?php

namespace Tenweb_Builder\includes;

class KitThemesMenu
{
    protected static $instance = NULL;
    private $themes;

    public function __construct()
    {
        $this->themes = get_option('twbb_all_kits_theme_info');
        $this->registerFontsPreview();
        if ( !empty($this->themes) ) {
            $this->View();
        }
    }

    private function registerFontsPreview() {
        wp_enqueue_style('twbb-roboto', 'https://fonts.googleapis.com/css?family=Roboto:400,100,100italic,300,300italic,400italic,500,500italic,700,700italic,900italic,900&display=swap',false);
        wp_enqueue_style('twbb-noto_serif', 'https://fonts.googleapis.com/css?family=Noto Serif:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&display=swap',false);
        wp_enqueue_style('twbb-montserrat', 'https://fonts.googleapis.com/css?family=Montserrat:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&display=swap',false);
        wp_enqueue_style('twbb-poppins', 'https://fonts.googleapis.com/css?family=Poppins:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&display=swap',false);
        wp_enqueue_style('twbb-nunito', 'https://fonts.googleapis.com/css?family=Nunito:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&display=swap',false);
        wp_enqueue_style('twbb-open-sans', 'https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,600,700,800&display=swap',false);
    }

    public static function getInstance() {
        if ( self::$instance === NULL ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    private function View() {
        ?>
        <div class="twbb-kit-themes-container">
            <p class="twbb-kit-themes-title">
                <?php _e('10Web Styles', 'tenweb-builder');?>
            </p>
            <div class="twbb-kit-themes">
            <?php
            foreach ($this->themes as $theme ) {
                $this->eachThemeView($theme);
            }
            ?>
            </div>
            <div class="twbb-kit-themes-save-button disabled" onclick="saveThemeKit()">
                <?php _e('Save Changes', 'tenweb-builder');?>
            </div>
        </div>
        <?php
    }

    private function eachThemeView($theme) {
        ?>
        <div class="twbb-kit-each-theme <?php esc_attr_e( $theme['class'] ); ?>"
             data-kit-name="<?php esc_attr_e( $theme['class'] ); ?>"
             style="background-color:<?php esc_attr_e( $theme['bg_color'] ); ?>;font-family:<?php esc_attr_e( $theme['kit-info']['font_family'] . ', sans-serif' ); ?>;"
             data-kit-info="<?php echo htmlspecialchars(json_encode($theme['kit-info']), ENT_QUOTES, 'UTF-8'); ?>"
             onclick="kitThemeChanges(this)">
            <div class="twbb-kit-theme-color-section">
                <div style="background-color:<?php esc_attr_e( $theme['color1']);?>"></div>
                <div style="background-color:<?php esc_attr_e( $theme['color2']);?>"></div>
            </div>
            <div class="twbb-kit-theme-title-section">
                <p class="twbb-kit-theme-name">
                    <?php
                    $translatedName = __($theme['name'],'tenweb-builder');
                    esc_html_e($translatedName);
                    ?>
                </p>
                <p class="twbb-kit-theme-description">
                    <?php
                    $translatedDesc = __($theme['desc'],'tenweb-builder');
                    esc_html_e($translatedDesc);
                    ?>
                </p>
            </div>
        </div>
        <?php
    }

}