<?php
namespace Tenweb_Builder;

use Elementor\Core\Settings\Page\Manager as PageManager;
use Elementor\Core\Utils\Svg\Svg_Sanitizer;

class Builder {
	public static $prefix = '';
	public static $version = '';
    private $editorVersion2 = false;
	protected static $instance = NULL;
	private $widgets_list = array();
	private $group_widgets_list = array();
	private $custom_options = array();
	private $tags_list = array();

	private function __construct() {
        self::$prefix             = TWBB_PREFIX;
		self::$version            = TWBB_VERSION;
		$this->widgets_list       = twbb_get_widgets();
		$this->group_widgets_list = twbb_get_group_widgets();
		$this->tags_list          = twbb_get_tags();
        $this->set_redirect_for_first_visit();

		if ( get_option( 'twbb_version' ) !== TWBB_VERSION ) {
            //TODOmove to install version===false after we will install elementor then builder in dashboard
            self::setElementorEditorVersion();
            //self::setElementorEditorExitWay();

			self::install();

            //TODO maybe change this and update only meta_value in wp_usermeta table
            update_option('elementor_experiment-e_global_styleguide', 'inactive');
		}

        //show tour to all users( open automatically one time )
        if ( get_option('twbb_tour_status') == false ) {
            update_option('twbb_tour_status', 'not_started');
        }
        $this->checkElementorEditorVersion();

		add_post_type_support( 'page', 'excerpt' );
		load_plugin_textdomain( 'tenweb-builder', FALSE, basename( dirname( __FILE__ ) ) . '/languages' );
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
        //add_action('admin_notices', array($this,'generate_admin_notices'));

		if ( ! $this->check_elementor_compatibility() ) {
			add_action( 'admin_notices', array( $this, 'elementor_compatibility_notice' ) );
		} else {
			if ( defined( 'ELEMENTOR_PATH' ) ) {
				include_once 'templates/templates.php';
				Templates::get_instance();
				$this->register_hooks();
				if ( ! defined( 'ELEMENTOR_PRO_VERSION' ) ) {
					$this->remove_elementor_upsell();
					$this->custom_options     = get_custom_options();
				}
				include_once TWBB_DIR . '/classes/woocommerce.php';
                require_once TWBB_DIR . '/widgets/woocommerce/settings-woocommerce.php';
				\Tenweb_Builder\Classes\Woocommerce\Woocommerce::get_instance();
			}
		}
        $this->connect_with_rest();

        $user = wp_get_current_user();
        if($user && !empty($user->roles) && in_array("administrator", $user->roles)){
            include_once 'includes/svg_upload.php';
            SVGUpload::get_instance();
        }
    }


  public static function install() {
		$version = get_option( 'twbb_version' );
		if ( $version === FALSE ) {
			$version = '0.0.0';
            self::setElementorEditorVersion();
		}
		if ( version_compare( $version, TWBB_VERSION, '<=' ) ) {
            //TODO
		}
		update_option( 'twbb_version', TWBB_VERSION );
        self::maybe_update_elementor_onboarding_option();
	}

    public static function maybe_update_elementor_onboarding_option() {
        $db_option = get_option( 'elementor_onboarded');

        if ( ! $db_option ) {
            update_option( 'elementor_onboarded', true );
        }
    }
    public function generate_admin_notices() {
        $error_logs = \Tenweb_Authorization\Helper::get_error_logs();
        if(!empty($error_logs)){
            foreach($error_logs as $error_key => $error) {
                echo '<div class="notice notice-error"><p>'.$error["msg"].'</p></div>';
            }
        }

    }

    public function connect_with_rest() {
        include_once 'rest_api.php';
        $restApi = new Twbb_RestApi;
    }

    private function check_elementor_compatibility() {
		if ( ! defined( 'ELEMENTOR_VERSION' ) || version_compare( ELEMENTOR_VERSION, TWBB_ELEMENTOR_MIN_VERSION, '<' ) || ! did_action( 'elementor/loaded' ) ) {
			return FALSE;
		}

		return TRUE;
	}

	// @TODO Temporary solution.
	private function register_hooks() {

        $this->register_controls();
		add_action( 'wp_ajax_twbb_widgets', array( $this, 'widgets_ajax' ) );
		add_action( 'wp_ajax_nopriv_twbb_widgets', array( $this, 'widgets_ajax' ) );
		add_action( 'wp_ajax_twbb_change_and_save_kit_options', array( $this, 'changeSaveKitOptions' ) );
		add_action( 'wp_ajax_twbb_update_tour_status', array( $this, 'updateTourStatus' ) );
		add_action( 'elementor/elements/categories_registered', array( $this, 'register_widget_category' ), 9 );
		add_action( 'elementor/widgets/register', array( $this, 'register_widgets' ), 10 );
		add_action( 'elementor/controls/controls_registered', array( $this, 'register_custom_options' ), 10 );
		/* @TODO SCRIPTS AND STYLES */
		add_action( 'elementor/frontend/after_register_styles', [ $this, 'enqueue_frontend_styles' ] );
		/* wp_footer action's third parameter need to be elementor's 'wp_footer' actions third parameter +1 */
		add_action( 'wp_footer', [ $this, 'enqueue_frontend_scripts' ], 12 );
		/* @TODO FIRES AFTER ELEMENTOR EDITOR STYLES AND SCRIPTS ARE ENQUEUED. */
		//fires after elementor editor styles and scripts are enqueued.
		add_filter( 'tw_get_elementor_assets', array( $this, 'register_elementor_assets' ) );
		add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'enqueue_editor_styles' ] );
		add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'enqueue_editor_scripts' ] );
		add_action( 'admin_bar_menu', [ $this, 'add_toolbar_items' ], 500 );
		add_action( 'wp_ajax_popup_template_ajax', array( $this, 'popup_template_ajax_action' ) );
		add_action( 'wp_ajax_remove_template_ajax', array( $this, 'remove_template_ajax_action' ) );
		add_action( 'wp_ajax_trigger_conditions', array( $this, 'trigger_conditions_admin_ajax' ) );
		add_action( 'wp_ajax_track_publish_ajax', array( $this, 'track_publish_ajax_action' ) );
		add_action( 'elementor/init', array( $this, 'elementor_init' ) );
		add_action( 'admin_init', array( $this, 'hide_elementor_upgrade_notice' ) );
		add_filter( 'elementor/widget/render_content', [ $this, 'remove_powered_by' ], 10, 3 );
		add_filter( 'elementor/widget/render_content', [ $this, 'remove_made_by_10web' ], 10, 3 );
        if ( is_array(get_option("twbb_imported_site_data_generated")) &&
            ( get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_regenerate' ||
                get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_recreate' ) ) {
            add_action('elementor/editor/footer', array($this, 'tourInit'));
        }
        /* do_action is called in demo plugin */
        add_filter( 'twbb_domain_init', array( $this, 'initDomain' ), 10, 2 );
        add_action( 'elementor/editor/footer', array($this, 'initDomain') );

        /* if menu item is created by AI or imported, remove class after editing it */
        add_action( 'wp_update_nav_menu_item',function($menu_id,$menu_item_id){
            $saved_menu = get_option('imported_nav_menu_' . $menu_id);
            $updated_menu = wp_get_nav_menu_items($menu_id);
            foreach ( $updated_menu as $key => $new_item ) {
                if ( $new_item->ID == $menu_item_id ) {
                    foreach ( $saved_menu as $old_item ) {
                        if ( $old_item->ID == $menu_item_id ) {
                            if ( $old_item->post_title != $new_item->post_title ||
                                $old_item->title != $new_item->title ||
                                $old_item->url != $new_item->url ) {
                                $item_classes = get_post_meta($menu_item_id,'_menu_item_classes')[0];
                                if (($key = array_search('ai-recreated-menu-item', $item_classes)) !== false) {
                                    unset($item_classes[$key]);
                                }
                                update_post_meta($menu_item_id,'_menu_item_classes',$item_classes);
                            }
                        }
                    }
                }
            }
        }, 10, 2 );

        include_once 'includes/cli.php';
        CLI::get_instance();
        $this->register_write_with_ai_hooks();
    }

       public function register_write_with_ai_hooks() {
               require_once(TWBB_DIR . '/ai/Utils.php');
           if ( get_option('elementor_experiment-fast_editing_tools') !== 'inactive' ) {
               require_once(TWBB_DIR . '/FastEditor/Tools/FastEditorTool.php');
               require_once(TWBB_DIR . '/FastEditor/Widgets/BaseWidgetFastEditor.php');
               require_once(TWBB_DIR . '/FastEditor/FastEditorDirector.php');
               $toolFiles = glob(TWBB_DIR . '/FastEditor/Tools' . '/*.php');
               foreach ($toolFiles as $file) {
                   require_once($file);
               }
               $widgetFiles = glob(TWBB_DIR . '/FastEditor/Widgets' . '/*.php');
               foreach ($widgetFiles as $file) {
                   require_once($file);
               }
               $fastEditorDirector = new FastEditor\FastEditorDirector();
               $fastEditorDirector->process();
           }
           //Write With AI sidebar part
           if ( TW_HOSTED_ON_10WEB ) {
               require_once 'ai/ai.php';
               new AITenwebBuilder();

               require_once 'ai/image_generation/ImageGeneration.php';
               new ImageGeneration();
           }
       }

       public function tourInit() {
        ?>
           <div class="twbb-tour-main-overlay twbb-tour-guide">
               <div class="twbb-tour-guide__container">
                   <p class="twbb-tour-guide__steps"></p>
                   <div class="twbb-tour-guide__video">
                       <video width="310" height="170" autoplay muted loop preload="auto"></video>
                       <span class="twbb-tour-zoom_in"></span>
                   </div>
                   <p class="twbb-tour-guide__title"></p>
                   <p class="twbb-tour-guide__description"></p>
                   <div class="twbb-tour-guide__buttons">
                       <div class="twbb-tour-guide__button twbb-tour-guide__left_button"></div>
                       <div class="twbb-tour-guide__button twbb-tour-guide__right_button"></div>
                   </div>
               </div>
           </div>
        <?php
       }

  public function hide_elementor_upgrade_notice() {
    update_option( '_elementor_editor_upgrade_notice_dismissed', 1 );
  }

	public function register_controls() {
		include_once 'controls/select-ajax/controller.php';
		SelectAjaxController::get_instance();
		if ( defined( 'ELEMENTOR_PATH' ) && class_exists( 'Elementor\Group_Control_Base' ) ) {
			include_once 'controls/query-control/controller.php';
			include_once 'controls/query-control/controls/group-control-posts.php';
			\Tenweb_Builder\Controls\QueryControl\QueryController::get_instance();
		}
	}

	private function remove_elementor_upsell() {
		include_once 'includes/remove-upsell.php';
		RemoveUpsell::get_instance();
	}

	/* Remove last imported template*/
	public static function get_instance() {
		if ( self::$instance === NULL ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function trigger_conditions_admin_ajax() {
		$post_id = Helper::get( 'post_id' );
		include_once 'templates/condition/admin-condition.php';
		$admincondition = new AdminCondition();
		$admincondition->admin_condition_popup( $post_id );
	}

	public function remove_powered_by( $content ) {
		$re = '/(Powered by 10Web)|(<a ?.*>Powered by 10Web<\/a>)/mi';
		preg_match( $re, $content, $matches, PREG_OFFSET_CAPTURE, 0 );
		if ( ! empty( $matches ) ) {
			$content = '';
		}

		return $content;
	}

    public function remove_made_by_10web($content) {
        $re = '/(Made by 10Web)|(<a ?.*><span ?.*>Made by 10Web<\/span><\/a>)/mi';
        preg_match( $re, $content, $matches, PREG_OFFSET_CAPTURE, 0 );
        if ( ! empty( $matches ) ) {
          $content = '';
        }

        return $content;
    }

	public function elementor_init() {
		require_once TWBB_DIR . '/dynamic-tags/module.php';
		new DynamicTags\Module();
		require_once TWBB_DIR . '/pro-features/ElementorPro.php';
		ElementorPro\ElementorPro::get_instance();
		if ( defined( 'ELEMENTOR_PATH' ) && class_exists( 'Elementor\Widget_Base' ) ) {
			if ( ! empty( $this->widgets_list ) ) {
				$widgets = array_merge( $this->widgets_list, $this->custom_options );
				foreach ( $widgets as $widget_name => $widget_data ) {
					if ( isset( $widget_data[ 'oninit' ] ) && $widget_data[ 'oninit' ] ) {
						$file = TWBB_DIR . '/widgets/' . $widget_name . '/' . $widget_name . '.php';
						if ( is_file( $file ) ) {
							require_once $file;
						}
					}
				}
			}
			if ( ! empty( $this->group_widgets_list ) ) {
				foreach ( $this->group_widgets_list as $module_name => $widget_data ) {
					$file = TWBB_DIR . '/widgets/' . $module_name . '/module.php';
					if ( is_file( $file ) ) {
						require_once $file;
					}
				}
			}
		}
        $this->register_fast_editor_tools_experiment();

	}

    public function initDomain($from_demo = FALSE, $twbb_domain_name_suggestion = FALSE ){
        require_once(TWBB_DIR . '/includes/PreviewUpgrade/DomainConnect.php');
        new DomainConnect($from_demo, $twbb_domain_name_suggestion);
    }

    private function register_fast_editor_tools_experiment() {
        \Elementor\Plugin::instance()->experiments->add_feature( [
            'name' => 'fast_editing_tools',
            'title' => esc_html__( 'Fast Editing Tools', 'tenweb-builder' ),
            'description' => esc_html__( 'Fast Editing Tools in Editor Preview part', 'tenweb-builder' ),
            'release_status' => \Elementor\Core\Experiments\Manager::RELEASE_STATUS_BETA,
            'new_site' => [
                'default_active' => true,
                'minimum_installation_version' => '3.1.0-beta',
            ],
        ] );
    }


	public function remove_template_ajax_action() {
		if ( ! isset( $_GET[ 'twbb_nonce' ] ) || ( isset( $_GET[ 'twbb_nonce' ] ) && ! wp_verify_nonce( $_GET[ 'twbb_nonce' ], 'twbb_remove_template_ajax' ) ) ) {
			$wp_error[ "message" ] = __( "You have no permission for the action", 'tenweb-builder' );
			$wp_error[ "status" ]  = "error";
			echo json_encode( $wp_error );
			die();
		}
		include_once 'templates/import/import.php';
		$args = array(
			'posts'       => 'delete',
			'attachments' => '1',
			'terms'       => '1',
			'menus'       => '1',
			'options'     => '1',
		);
		Import::delete_last_imported_site_data( $args , 'twbb_imported_site_data_generated');
	}

	public function popup_template_ajax_action() {
		include_once 'templates/popupTemplates.php';
		$task = Helper::get( 'task' );
		switch ( $task ) {
			case 'save_lacaly':
				PopupTemplates::get_instance()->twbb_dublicate_teplate_post();
				break;
			case 'save_popup':
				if ( Helper::get( 'header_template' ) === '0' || Helper::get( 'footer_template' ) === '0' || Helper::get( 'single_template' ) === '0' || Helper::get( 'archive_template' ) === '0' ) {
					$param = "exclude";
				} else {
					$param = "include";
				}
				PopupTemplates::get_instance()->twbb_save_templates( $param );
		}
	}

    public function track_publish_ajax_action() {
      update_option('twbb_track_publish_button', 1);
    }

	public function add_toolbar_items( \WP_Admin_Bar $admin_bar ) {

		if ( ! is_admin() ) {


			$edit_url       = $this->get_edit_url();
			if ( ! TENWEB_WHITE_LABEL ) {
				$admin_bar->remove_menu( 'elementor_edit_page' );

				if ( is_singular() ) {
                    $page_id = get_the_ID();
					$document = \Elementor\Plugin::instance()->documents->get_doc_for_frontend( $page_id );
					if ( $document && $document->is_editable_by_current_user() ) {
						$admin_bar->add_menu( array(
							                      'id'    => 'twbb_builder',
							                      'class' => 'admin_bar-twbb_builder',
							                      'title' => __( 'Edit with 10Web Builder', 'tenweb-builder' ),
							                      'href'  => $edit_url,
						                      ) );
                        if ( \Elementor\Plugin::$instance->documents->get( $page_id )->is_built_with_elementor() ) {
                            $admin_bar->remove_node( 'edit' );
                        }
					}
					if ( is_singular( array( 'product' ) ) ) {
						$loaded_templates = Templates::get_instance()->get_loaded_templates();
						if ( array_key_exists( 'twbb_single', $loaded_templates ) && ! empty( $loaded_templates[ 'twbb_single' ] ) ) {
                            $template_id = $loaded_templates[ 'twbb_single' ];
							$document    = \Elementor\Plugin::instance()->documents->get_doc_for_frontend( $template_id );
							if ( $document && $document->is_editable_by_current_user() ) {
                                $admin_bar->remove_node( 'edit' );
								$admin_bar->add_menu( array(
									                      'id'    => 'twbb_builder',
									                      'class' => 'admin_bar-twbb_builder',
									                      'title' => __( 'Edit Product template with 10Web Builder', 'tenweb-builder' ),
									                      'href'  => $edit_url,
									                      'meta'  => array( 'target' => '_blank' ),
								                      ) );
							}
						}
					}
				} else {
                    $page_id = get_the_ID();
					$loaded_templates = Templates::get_instance()->get_loaded_templates();
					if ( array_key_exists( 'twbb_archive', $loaded_templates ) && ! empty( $loaded_templates[ 'twbb_archive' ] ) ) {
						$archive_id = $loaded_templates[ 'twbb_archive' ];
						$document   = \Elementor\Plugin::instance()->documents->get_doc_for_frontend( $archive_id );
						if ( $document && $document->is_editable_by_current_user() && !empty($page_id) ) {
                            if ( \Elementor\Plugin::$instance->documents->get( $page_id )->is_built_with_elementor() ) {
                                $admin_bar->remove_node( 'edit' );
                            }

                            $admin_bar->add_menu( array(
								                      'id'    => 'twbb_builder',
								                      'class' => 'admin_bar-twbb_builder',
								                      'title' => __( 'Edit Archive template with 10Web Builder', 'tenweb-builder' ),
								                      'href'  => $edit_url,
								                      'meta'  => array( 'target' => '_blank' ),
							                      ) );
						}
					}
				}
			}

          if ($edit_url && 1 == get_post_meta( get_the_ID(), 'twbb_ai_created', TRUE )
                && (isset( $_GET['preview_sidebar'] ) || get_option('twbb_sidebar')) ) {
                ?>
                <script type="text/javascript">
                    let url, new_url;
                    url = window.location.href;
                    new_url = url.split('?')[0];
                    window.history.pushState({}, document.title, new_url);
                </script>
                <style>
                    html {
                        margin-top: 0 !important;
                    }

                    #wpadminbar {
                        display: none;
                    }
                </style>
                <?php include_once "includes/PreviewUpgrade/PreviewUpgrade.php";
                new PreviewUpgrade();

                update_option( 'twbb_sidebar', true );
			}
		}

  }

	public static function get_edit_url() {
		if ( ! is_admin() ) {
			$edit_url = FALSE;
			if ( is_singular() ) {
				$document = \Elementor\Plugin::instance()->documents->get_doc_for_frontend( get_the_ID() );
				if ( $document && $document->is_editable_by_current_user() ) {
					$edit_url = $document->get_edit_url();
				}
				if ( is_singular( array( 'product' ) ) ) {
					$loaded_templates = Templates::get_instance()->get_loaded_templates();
					if ( array_key_exists( 'twbb_single', $loaded_templates ) && ! empty( $loaded_templates[ 'twbb_single' ] ) ) {
						$template_id = $loaded_templates[ 'twbb_single' ];
						$document    = \Elementor\Plugin::instance()->documents->get_doc_for_frontend( $template_id );
						if ( $document && $document->is_editable_by_current_user() ) {
							$edit_url = admin_url( 'post.php?post=' . $template_id . '&action=elementor' );
						}
					}
				}
			} else {
				$loaded_templates = Templates::get_instance()->get_loaded_templates();
				if ( array_key_exists( 'twbb_archive', $loaded_templates ) && ! empty( $loaded_templates[ 'twbb_archive' ] ) ) {
					$archive_id = $loaded_templates[ 'twbb_archive' ];
					$document   = \Elementor\Plugin::instance()->documents->get_doc_for_frontend( $archive_id );
					if ( $document && $document->is_editable_by_current_user() ) {
						$edit_url = admin_url( 'post.php?post=' . $archive_id . '&action=elementor' );
					}
				}
			}

			return $edit_url;
		}
	}

	public function register_widgets() {
		if ( defined( 'ELEMENTOR_PATH' ) && class_exists( 'Elementor\Widget_Base' ) ) {
			if ( ! empty( $this->widgets_list ) ) {
				$isExternal = FALSE;
				foreach ( $this->widgets_list as $widget_name => $widget_data ) {
					if ( ! isset( $widget_data[ 'oninit' ] ) || ! $widget_data[ 'oninit' ] ) {
						if ( isset( $widget_data[ 'external' ] ) && $widget_data[ 'external' ] ) {
							if ( isset( $widget_data[ 'class_name' ] ) && ! class_exists( $widget_data[ 'class_name' ] ) ) {
								$isExternal = TRUE;
								require_once TWBB_DIR . '/widgets/external/external.php';
								$external_widget = new External();
								$external_widget->set( $widget_data );
								\Elementor\Plugin::instance()->widgets_manager->register( $external_widget );
							}
						} else {
							$file = TWBB_DIR . '/widgets/' . $widget_name . '/' . $widget_name . '.php';
							if ( is_file( $file ) ) {
                                require_once $file;
							}
						}
					}
				}
				if ( $isExternal && class_exists( '\Tenweb_Manager\Manager' ) && is_admin() ) {
					wp_enqueue_script( 'twbb-control-external-ajax', TWBB_URL . '/assets/editor/js/external-ajax.js', [ 'jquery' ], TWBB_VERSION );
					$rest_route = add_query_arg( array(
						                             'rest_route' => '/' . TENWEB_REST_NAMESPACE . '/action',
					                             ), get_home_url() . "/" );
					wp_localize_script( 'twbb-control-external-ajax', 'twbb', array(
						'ajaxurl'          => admin_url( 'admin-ajax.php' ),
						'ajaxnonce'        => wp_create_nonce( 'wp_rest' ),
						'plugin_url'       => TENWEB_URL,
						'action_endpoint'  => $rest_route,
						'install_success'  => __( 'The plugin was successfully installed and activated. Please save your changes and reload the page for using the widget', 'tenweb-builder' ),
						'activate_success' => __( 'The plugin was successfully activated. Please save your changes and reload the page for using the widget', 'tenweb-builder' ),
						'update_success'   => __( 'The plugin was successfully updated. Please save your changes and reload the page for using the widget', 'tenweb-builder' ),
						'reload_msg'       => __( 'Please save your changes and reload the page for using the widget', 'tenweb-builder' ),
						'inprogress_msg'   => __( 'Some plugin is in the process of being activated or installed.', 'tenweb-builder' ),
					) );
				}
			}
		}

  }

	public function register_custom_options() {
		if ( defined( 'ELEMENTOR_PATH' ) && class_exists( 'Elementor\Widget_Base' ) ) {
			if ( ! empty( $this->custom_options ) ) {
				foreach ( $this->custom_options as $widget_name => $widget_data ) {
					if ( ! isset( $widget_data[ 'oninit' ] ) || ! $widget_data[ 'oninit' ] ) {
						$file = TWBB_DIR . '/widgets/' . $widget_name . '/' . $widget_name . '.php';
						if ( is_file( $file ) ) {
							require_once $file;
						}
					}
				}
			}

    }
	}

	public function widgets_ajax() {
		if ( ! check_ajax_referer( 'twbb', 'nonce' ) || ! isset( $_REQUEST[ 'widget_name' ] ) ) {
			wp_send_json_error();
		}
		$widget = twbb_get_widgets( $_REQUEST[ 'widget_name' ] );
		if ( ! isset( $widget[ 'ajax' ] ) || $widget[ 'ajax' ] !== TRUE ) {
			wp_send_json_error();
		}
		$file = TWBB_DIR . '/widgets/' . $_REQUEST[ 'widget_name' ] . '/' . $_REQUEST[ 'widget_name' ] . '.php';
		if ( is_file( $file ) ) {
			require_once $file;
			$class_name = "\Tenweb_Builder\\" . ucfirst( $_REQUEST[ 'widget_name' ] );
			$method     = 'twbb_ajax';
			if ( method_exists( $class_name, $method ) ) {
				$class_name::$method();
			}
		}
	}

	/**
	 * @param $elements_manager \Elementor\Elements_Manager
	 * */
	public function register_widget_category( $elements_manager ) {
		$company_name = '10Web ';
		if ( TENWEB_WHITE_LABEL ) {
			$company_name = '';
		}
		$elements_manager->add_category(
			'tenweb-widgets',
			[
				'title' => __( $company_name . 'Premium widgets', 'tenweb-builder' ),
				'icon'  => 'fa fa-plug',
			]
		);
		$elements_manager->add_category(
			'tenweb-plugins-widgets',
			[
				'title' => __( '10WEB Plugins', 'tenweb-builder' ),
				'icon'  => 'fa fa-plug',
			]
		);
		/* show sections only on template page! */
        if (Templates::get_instance()->is_elementor_template_type()) {
            $elements_manager->add_category(
                'tenweb-builder-widgets',
                [
                    'title' => __('Site Builder Widgets' . $company_name, 'tenweb-builder'),
                    'icon' => 'fa fa-plug',
                ]
            );
            $elements_manager->add_category(
                'tenweb-woocommerce-builder-widgets',
                [
                    'title' => __('Woocommerce Builder Widgets' . $company_name, 'tenweb-builder'),
                    'icon' => 'fa fa-plug',
                ]
            );
        }
		$elements_manager->add_category(
			'tenweb-woocommerce-widgets',
			[
				'title' => __( 'Woocommerce Widgets' . $company_name, 'tenweb-builder' ),
				'icon'  => 'fa fa-plug',
			]
		);
	}

	public function enqueue_frontend_scripts() {
		// For post archive widget.
		wp_enqueue_script( 'underscore' );
		// Do not include admin scripts to front.
		if ( \Elementor\Plugin::instance()->preview->is_preview_mode() ) {
			$handle_editor = 'twbb-common-js';
			wp_enqueue_script( 'jquery-elementor-select2' );
			wp_enqueue_script( 'twbb-common-js', TWBB_URL . '/assets/common/js/common.js', [ 'jquery' ], TWBB_VERSION, TRUE );
            wp_enqueue_script( 'twbb-editor-helper-script', TWBB_URL . '/assets/editor/js/helper-script.js', array('jquery'), TWBB_VERSION, TRUE );
			wp_enqueue_script( 'twbb-condition-js', TWBB_URL . '/assets/editor/js/condition.js', [ 'jquery','twbb-editor-helper-script' ], TWBB_VERSION, TRUE );
			wp_enqueue_style( 'twbb-common', TWBB_URL . '/assets/common/css/common.css', array(), TWBB_VERSION );
            if ( $this->editorVersion2 ) {
                wp_enqueue_style( 'twbb-editor_v2', TWBB_URL . '/assets/editor/css/editor_v2.css', array(), TWBB_VERSION );
                wp_enqueue_script( 'twbb-editor-scripts-v2', TWBB_URL . '/assets/editor/js/editor_v2.js', [ 'jquery' ], TWBB_VERSION, TRUE );

                if ( is_array(get_option("twbb_imported_site_data_generated")) &&
                ( get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_regenerate' ||
                   get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_recreate' ) ) {
                    wp_register_style('twbb-open-sans', 'https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,600,700,800&display=swap');

                    wp_enqueue_style( 'twbb-editor-tour-style', TWBB_URL . '/assets/editor/css/tour.css', array('twbb-open-sans'), TWBB_VERSION );
                }

            }
            else {
                wp_enqueue_style( 'twbb-editor_v1', TWBB_URL . '/assets/editor/css/editor_v1.css', array(), TWBB_VERSION );
            }
			wp_enqueue_style( 'twbb-condition', TWBB_URL . '/assets/editor/css/condition.css', array(), TWBB_VERSION );
			$rest_route         = add_query_arg( array( 'rest_route' => '/' ), get_home_url() . "/" );
			$twbb_template_type = Templates::get_instance()->is_twbb_template()[ 'template_type' ];
			$header_button      = Templates::get_instance()->is_twbb_template()[ 'header_button_show' ];
            $localizedArrayOptions = array(
                'loaded_templates'    => Templates::get_instance()->get_loaded_templates(),
                'post_id'             => get_the_ID(),
                'current_page'        => __( 'Current Page', 'tenweb-builder' ),
                'entire_site'         => __( 'Entire Site', 'tenweb-builder' ),
                'singular'            => __( 'Singular', 'tenweb-builder' ),
                'archive'             => __( 'Archive', 'tenweb-builder' ),
                'choose'              => __( 'Choose', 'tenweb-builder' ),
                'template'            => __( 'template', 'tenweb-builder' ),
                'twbb_page_type'      => Condition::get_instance()->get_page_type(),
                'edit'                => __( 'Edit', 'tenweb-builder' ),
                'edit_localy'         => __( 'Edit Localy', 'tenweb-builder' ),
                'edit_url'            => admin_url( 'post.php?post={post_id}&action=elementor' ),
                'popup_template_ajax' => add_query_arg( array( 'action' => 'popup_template_ajax' ), admin_url( 'admin-ajax.php' ) ),
                'is_post_template'    => ( get_post_type( get_the_ID() ) == 'elementor_library' ? 1 : 0 ),
                'header_button'       => $header_button,
                'twbb_header'         => __( 'Edit Header Template', 'tenweb-builder' ),
                'twbb_footer'         => __( 'Edit Footer Template', 'tenweb-builder' ),
                'twbb_single'         => __( 'Edit Single Template', 'tenweb-builder' ),
                'twbb_archive'        => __( 'Edit Archive Template', 'tenweb-builder' ),
                'twbb_template_type'  => $twbb_template_type,
                'plugin_url'          => plugin_dir_url( __FILE__ ),
                'editor_v2'           => $this->editorVersion2,
                'dashboard_url'       => esc_url(self::checkManagerExistence()['dashboard_url']),
            );
			wp_localize_script( $handle_editor, 'twbb_options', $localizedArrayOptions );
			wp_localize_script( $handle_editor, 'twbb_editor', array(
				'texts'              => array(
					'include'           => __( 'Include', 'tenweb-builder' ),
					'exclude'           => __( 'Exclude', 'tenweb-builder' ),
					'general'           => __( 'Entire Site', 'tenweb-builder' ),
					'archive'           => __( 'Archive', 'tenweb-builder' ),
					'singular'          => __( 'Singular', 'tenweb-builder' ),
					'are_your_sure'     => __( 'Are you sure?', 'tenweb-builder' ),
					'condition_removed' => __( 'A condition has been removed.', 'tenweb-builder' ),
					'content_missing'   => __( 'Warning: There are no content widgets in this Single template. Please make sure to add some.', 'tenweb-builder' ),
					'publish'           => __( 'Publish', 'tenweb-builder' ),
					'continue'          => __( 'Continue', 'tenweb-builder' ),
				),
				'ajax_url'           => admin_url( 'admin-ajax.php' ),
				'rest_route'         => $rest_route,
				'rest_nonce'         => wp_create_nonce( 'wp_rest' ),
				'post_id'            => get_the_ID(),
				'conditions'         => Condition::get_instance()->get_template_condition( get_the_ID(), 'all', TRUE ),
				'twbb_template_type' => $twbb_template_type,
			) );

            wp_enqueue_script( 'twbb-editor-helper-script', TWBB_URL . '/assets/editor/js/helper-script.js', array('jquery'), TWBB_VERSION, TRUE );
            wp_localize_script( 'twbb-editor-helper-script', 'twbb_helper', array(
                    'domain_id' => get_option('tenweb_domain_id'))
            );
		}
		$handle_frontend = 'twbb-frontend-scripts';
        if ( ! defined( 'ELEMENTOR_PRO_VERSION' ) ) {
            if (TWBB_DEBUG === TRUE) {
                $sticky_lib_url = TWBB_URL . '/widgets/sticky/assets/js/jquery.sticky.js';
            } else {
                $sticky_lib_url = TWBB_URL . '/widgets/sticky/assets/js/jquery.sticky.min.js';
            }
            wp_enqueue_script( 'twbb-sticky', $sticky_lib_url, ['jquery'], TWBB_VERSION, true );

            $frontend_dependency = [
                'elementor-frontend-modules',
                'imagesloaded',
                'masonry',
                'twbb-sticky',
            ];
        } else {
            $frontend_dependency = [
                'elementor-frontend-modules',
                'imagesloaded',
                'masonry',
            ];
        }

        if ( class_exists('woocommerce') ) {
            array_push($frontend_dependency, 'wc-cart-fragments' );
        }
		if ( TWBB_DEV === FALSE ) {
			if ( TWBB_DEBUG === TRUE ) {
				wp_enqueue_script( 'twbb-frontend-scripts', TWBB_URL . '/assets/frontend/js/frontend.js',
                    $frontend_dependency,                 TWBB_VERSION );
			} else {
                wp_enqueue_script( 'twbb-frontend-scripts', TWBB_URL . '/assets/frontend/js/frontend.min.js',
                    $frontend_dependency,                 TWBB_VERSION );
			}
		} else {
			$handle_frontend = 'twbb-posts-scripts';
			$widgets         = array_merge( $this->widgets_list, $this->custom_options );
			foreach ( $widgets as $widget_data ) {
				if ( empty( $widget_data[ 'scripts' ] ) ) {
					continue;
				}
				foreach ( $widget_data[ 'scripts' ] as $handle => $script_data ) {
					wp_enqueue_script( 'twbb-' . $handle . '-scripts', $script_data[ 'src' ], $script_data[ 'deps' ], TWBB_VERSION, TRUE );
				}
			}
		}
        $twbb_script_localize = [
            'ajaxurl'  => admin_url( 'admin-ajax.php' ),
            'home_url' => home_url(),
            'nonce'    => wp_create_nonce( 'twbb' ),
            'tenweb_dashboard' => TENWEB_DASHBOARD,
            'swiper_latest' => get_option("elementor_experiment-e_swiper_latest")
        ];
        if ( is_user_logged_in() ) {
            $twbb_script_localize['dashboard_website_id'] = get_option('tenweb_domain_id');
        }
        wp_localize_script( $handle_frontend, 'twbb', $twbb_script_localize );

		do_action( 'twbb_after_enqueue_scripts', $handle_frontend );
        if ( \Elementor\Plugin::instance()->preview->is_preview_mode() ) {
			include_once 'includes/quick-navigation.php';
			$structure = new Quick_Navigation();
			$structure->twbb_custom_header();
			$structure->twbb_template_popup();
            if ( $this->editorVersion2 ) {
                $structure->websiteStructure();
                if ( is_array(get_option("twbb_imported_site_data_generated")) && get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_regenerate' ) {
                    //Saving only custom_colors id's because the system_colors id's are not changeable
                    $kit = \Elementor\Plugin::instance()->kits_manager->get_current_settings()['custom_colors'];
                    $kitTypo = \Elementor\Plugin::instance()->kits_manager->get_current_settings()['custom_typography'];
                    $kitColorsIDs = [];
                    $kitTypographyIDs = [];
                    foreach ($kit as $each_item) {
                        $kitColorsIDs[$each_item['title']] = $each_item['_id'];
                    }
                    foreach ($kitTypo as $each_item) {
                        $kitTypographyIDs[$each_item['title']] = $each_item['_id'];
                    }
                    update_option('twbb_imported_kit_ids', $kitColorsIDs);
                    update_option('twbb_imported_kit_typo_ids', $kitTypographyIDs);
                    include_once 'includes/KitThemesMenu.php';
                    \Tenweb_Builder\includes\KitThemesMenu::getInstance();
                }
            }
		}
		if ( ! TENWEB_WHITE_LABEL ) {
			/* remove 'Edit with Elementor' from admin bar */
			wp_dequeue_script( 'elementor-admin-bar' );
		}
	}

	public function enqueue_frontend_styles() {
		if ( TWBB_DEV === FALSE ) {
			wp_enqueue_style( 'twbb-frontend-styles', TWBB_URL . '/assets/frontend/css/frontend.css', array(
				'elementor-frontend'
			),                TWBB_VERSION );
			// Ensure the images remain visible while meta information is being generated after import.
			if ( get_option( 'tenweb_import_in_progress' ) ) {
				wp_add_inline_style( 'twbb-frontend-styles', 'img {width: initial !important; height: initial !important;}' );
			}
		}
        else {
			wp_enqueue_style( 'twbb-fonts', TWBB_URL . '/assets/frontend/css/fonts.css', array(), TWBB_VERSION );
			$widgets = array_merge( $this->widgets_list, $this->custom_options );
			foreach ( $widgets as $widget_data ) {
				if ( empty( $widget_data[ 'styles' ] ) ) {
					continue;
				}
				foreach ( $widget_data[ 'styles' ] as $handle => $style_data ) {
					if ( is_array( $style_data ) ) {
                        $deps = array_merge($style_data['deps'], ['elementor-frontend']);
						wp_enqueue_style( 'twbb-' . $handle . '-style', $style_data[ 'src' ], $deps, TWBB_VERSION );
					} else {
						wp_enqueue_style( $handle );
					}
				}
			}
		}
        wp_enqueue_style( 'twbb-frontend-global-styles', TWBB_URL . '/assets/frontend/css/global_frontend.css', array(),TWBB_VERSION );
		do_action( 'twbb_after_enqueue_styles' );
	}

	public function register_elementor_assets( $assets ) {
		$version = '2.0.2';
		if ( ! isset( $assets[ 'version' ] ) || version_compare( $assets[ 'version' ], $version ) === - 1 ) {
			$assets[ 'version' ]  = $version;
			$assets[ 'css_path' ] = TWBB_URL . '/assets/frontend/css/fonts.css';
		}

		return $assets;
	}

	public function enqueue_editor_styles() {
	    $handle_for_old_version = "";
		if ( TWBB_DEV === FALSE ) {
			wp_enqueue_style( 'twbb-admin-styles', TWBB_URL . '/assets/editor/css/editor.min.css', array(), TWBB_VERSION );
      self::hide_elementor_AI( 'twbb-admin-styles' );
            $handle_for_old_version = "twbb-admin-styles";
        } else {
            $handle_for_old_version = "twbb-common";
            $key = 'twbb-editor-styles';
			wp_deregister_style( $key );
			$assets = apply_filters( 'tw_get_elementor_assets', array() );
			wp_enqueue_style( $key, $assets[ 'css_path' ], array(), $assets[ 'version' ] );
			wp_enqueue_style( 'twbb-el-editor-styles', TWBB_URL . '/assets/editor/css/editor.css', array(), TWBB_VERSION );
      self::hide_elementor_AI( 'twbb-el-editor-styles' );
      wp_enqueue_style( 'twbb-condition', TWBB_URL . '/assets/editor/css/condition.css', array(), TWBB_VERSION );
			wp_enqueue_style( 'twbb-common', TWBB_URL . '/assets/common/css/common.css', array(), TWBB_VERSION );
            wp_enqueue_style( 'twbb-frontend-global-styles', TWBB_URL . '/assets/frontend/css/global_frontend.css', array(),TWBB_VERSION );
		}

		// Compatibility with Font awesome 5, remove once Elementor deprecates fa4.
		wp_enqueue_style( 'font-awesome-5-all', self::get_fa_asset_url( 'all' ), array(), ELEMENTOR_VERSION );

		if(defined('ELEMENTOR_VERSION') && version_compare(ELEMENTOR_VERSION, '3.12.0') == -1) {
		    wp_add_inline_style($handle_for_old_version, "#elementor-panel #elementor-panel-content-wrapper {top: 60px !important;}");
		}

		if ( TENWEB_WHITE_LABEL ) {
			wp_enqueue_style( 'twbb-white-label', TWBB_URL . '/assets/common/css/white_label.css', array(), TWBB_VERSION );
		}

	}

  /**
   * Hide Elementor AI suggestion buttons if Pro version is not active.
   *
   * @param $style_hook string
   */
  public static function hide_elementor_AI( $style_hook ) {
    $custom_css = "#e-announcements-root, .e-ai-button:not(.twb-ai-button) { display: none!important; }";
    wp_add_inline_style( $style_hook, $custom_css );
  }

	public static function get_fa_asset_url( $filename, $ext_type = 'css', $add_suffix = TRUE ) {
		static $is_test_mode = NULL;
		if ( NULL === $is_test_mode ) {
			$is_test_mode = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG || defined( 'ELEMENTOR_TESTS' ) && ELEMENTOR_TESTS;
		}
		$url = ELEMENTOR_ASSETS_URL . 'lib/font-awesome/' . $ext_type . '/' . $filename;
		if ( ! $is_test_mode && $add_suffix ) {
			$url .= '.min';
		}

		return $url . '.' . $ext_type;
	}

    public static function checkManagerExistence() {
        /* Check is manager exists and is domain id in options */
        $manager_exist = false;
        $if_trial_user = false;
        $ai_created = false;
        $dashboard_url = false;
        $subscription_id = false;
        if ( class_exists( '\Tenweb_Manager\Manager' ) ) {
            $domain_id = get_site_option( TENWEB_PREFIX . '_domain_id' );
            $user_agreements_info = \Tenweb_Manager\Helper::get_tenweb_user_info()[ 'agreement_info'];
            if ( is_array($user_agreements_info) && !empty($user_agreements_info) ) {
                $subscription_id = $user_agreements_info['subscription_id'];
                $if_trial_user = ($user_agreements_info['subscription_category'] == 'starter' && $user_agreements_info['hosting_trial_expire_date'] != '') ? true : false;
                $ai_created = (261 == $user_agreements_info['subscription_id'] || 211 == $user_agreements_info['subscription_id']);
            }
            if ( $domain_id ) {
                $manager_exist = true;
            }
            $dashboard_url = $manager_exist ? TENWEB_DASHBOARD . '/websites/'. $domain_id . '/ai-builder/' : 'https://my.10web.io/websites/';

        }

        return(compact('if_trial_user', 'ai_created', 'dashboard_url', 'subscription_id'));
    }

    public function checkElementorEditorVersion() {
        //TODO check when elementor will change default status to active we need to change here too
        if ( get_option('elementor_experiment-editor_v2') == 'active' ) {
            $this->editorVersion2 = true;
        }
    }

    public static function setElementorEditorVersion() {
        update_option('elementor_experiment-editor_v2', 'active' );
    }

    public static function setElementorEditorExitWay() {
        $elementorPreferencesMeta = get_user_meta( get_current_user_id(), 'elementor_preferences');

        if ( $elementorPreferencesMeta ) {
            $elementorPreferencesMeta['exit_to'] = 'dashboard';
            update_user_meta( get_current_user_id(), 'elementor_preferences', $elementorPreferencesMeta );
        }
    }

	public function enqueue_editor_scripts() {
		if ( TWBB_DEV === FALSE ) {
			$requirements = array(
				'jquery',
				'backbone-marionette',
				'elementor-common-modules',
				'elementor-common',
				'elementor-editor-modules',
				'elementor-editor-document',
			);
			if ( TWBB_DEBUG === TRUE ) {
				wp_enqueue_script( 'twbb-editor-scripts', TWBB_URL . '/assets/editor/js/editor-tenweb.js', $requirements, TWBB_VERSION, TRUE );
			} else {
				wp_enqueue_script( 'twbb-editor-scripts', TWBB_URL . '/assets/editor/js/editor-tenweb.min.js', $requirements, TWBB_VERSION, TRUE );
			}
		} else {
			foreach ( $this->widgets_list as $widget_data ) {
				if ( empty( $widget_data[ 'admin-scripts' ] ) ) {
					continue;
				}
				foreach ( $widget_data[ 'admin-scripts' ] as $handle => $script_data ) {
					wp_enqueue_script( 'twbb-' . $handle . '-admin-scripts', $script_data[ 'src' ], $script_data[ 'deps' ], TWBB_VERSION, TRUE );
				}
			}
			wp_enqueue_script( 'twbb-editor-scripts', TWBB_URL . '/assets/editor/js/editor.js', [ 'jquery' ], TWBB_VERSION, TRUE );
            wp_enqueue_script( 'twbb-editor-helper-script', TWBB_URL . '/assets/editor/js/helper-script.js', array('jquery'), TWBB_VERSION, TRUE );
			wp_enqueue_script( 'twbb-condition-js', TWBB_URL . '/assets/editor/js/condition.js', [ 'jquery','twbb-editor-helper-script' ], TWBB_VERSION, TRUE );
			wp_enqueue_script( 'twbb-common-js', TWBB_URL . '/assets/common/js/common.js', [ 'jquery' ], TWBB_VERSION, TRUE );
            wp_enqueue_script( 'twbb-editor-helper-script', TWBB_URL . '/assets/editor/js/helper-script.js', array('jquery'), TWBB_VERSION, TRUE );
            wp_localize_script( 'twbb-editor-helper-script', 'twbb_helper', array(
                    'domain_id' => get_option('tenweb_domain_id'))
            );
            wp_enqueue_script( 'twbb-editor-ga-events-script', TWBB_URL . '/assets/editor/js/ga_events.js', array('jquery'), TWBB_VERSION, TRUE );
        }

		$rest_route         = add_query_arg( array( 'rest_route' => '/' ), get_home_url() . "/" );
		$twbb_template_type = Templates::get_instance()->is_twbb_template()[ 'template_type' ];
        $localizedArrayEditor = array(
            'texts'              => array(
                'include'           => __( 'Include', 'tenweb-builder' ),
                'exclude'           => __( 'Exclude', 'tenweb-builder' ),
                'general'           => __( 'Entire Site', 'tenweb-builder' ),
                'archive'           => __( 'Archive', 'tenweb-builder' ),
                'singular'          => __( 'Singular', 'tenweb-builder' ),
                'are_your_sure'     => __( 'Are you sure?', 'tenweb-builder' ),
                'condition_removed' => __( 'A condition has been removed.', 'tenweb-builder' ),
                'content_missing'   => __( 'Warning: There are no content widgets in this Single template. Please make sure to add some.', 'tenweb-builder' ),
                'publish'           => __( 'Publish', 'tenweb-builder' ),
                'continue'          => __( 'Continue', 'tenweb-builder' ),
            ),
            'ajax_url'           => admin_url( 'admin-ajax.php' ),
            'rest_route'         => $rest_route,
            'rest_nonce'         => wp_create_nonce( 'wp_rest' ),
            'post_id'            => get_the_ID(),
            'conditions'         => Condition::get_instance()->get_template_condition( get_the_ID(), 'all', TRUE ),
            'twbb_template_type' => $twbb_template_type,
        );
		wp_localize_script( 'twbb-editor-scripts', 'twbb_editor', $localizedArrayEditor );
        wp_localize_script( 'twbb-editor-scripts', 'twbb_helper', array(
                'domain_id' => get_option('tenweb_domain_id'))
        );
		$edit_url         = admin_url( 'post.php?post={post_id}&action=elementor' );
		$is_post_template = ( get_post_type( get_the_ID() ) == 'elementor_library' ? 1 : 0 );
		$header_button    = Templates::get_instance()->is_twbb_template()[ 'header_button_show' ];
        if ( $this->editorVersion2 ) {
            wp_enqueue_style( 'twbb-editor_v2', TWBB_URL . '/assets/editor/css/editor_v2.css', array(), TWBB_VERSION );
            wp_enqueue_script( 'twbb-editor-scripts-v2', TWBB_URL . '/assets/editor/js/editor_v2.js', [ 'jquery' ], TWBB_VERSION, TRUE );
            wp_register_style('twbb-open-sans', 'https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,600,700,800&display=swap');

            if ( is_array(get_option("twbb_imported_site_data_generated")) && get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_regenerate' ) {
                wp_enqueue_script( 'twbb-editor-kit-themes-script', TWBB_URL . '/assets/editor/js/kit-themes.js', [ 'jquery' ], TWBB_VERSION, TRUE );
                wp_register_style('twbb-roboto', 'https://fonts.googleapis.com/css?family=Roboto:400,100,100italic,300,300italic,400italic,500,500italic,700,700italic,900italic,900&display=swap');
                wp_register_style('twbb-noto_serif', 'https://fonts.googleapis.com/css?family=Noto Serif:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&display=swap');
                wp_register_style('twbb-montserrat', 'https://fonts.googleapis.com/css?family=Montserrat:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&display=swap');
                wp_register_style('twbb-poppins', 'https://fonts.googleapis.com/css?family=Poppins:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&display=swap');
                wp_register_style('twbb-nunito', 'https://fonts.googleapis.com/css?family=Nunito:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&display=swap');
                wp_register_style('twbb-open-sans', 'https://fonts.googleapis.com/css?family=Open+Sans:300,400,500,600,700,800&display=swap');
                wp_enqueue_style( 'twbb-editor-kit-themes-style', TWBB_URL . '/assets/editor/css/kit-themes.css', array('twbb-roboto','twbb-noto_serif','twbb-montserrat','twbb-poppins','twbb-open-sans','twbb-nunito'), TWBB_VERSION );
            }
            if ( is_array(get_option("twbb_imported_site_data_generated")) &&
                ( get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_regenerate' ||
                    get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_recreate' ) ) {
                wp_enqueue_style( 'twbb-editor-tour-style', TWBB_URL . '/assets/editor/css/tour.css', array('twbb-open-sans'), TWBB_VERSION );
                wp_enqueue_script( 'twbb-editor-tour-script', TWBB_URL . '/assets/editor/js/tour.js', [ 'jquery' ], TWBB_VERSION, TRUE );

                //TODO move to separate file
                $tour_content_variables = array(
                    'all_steps_count' => 6,
                    '0' => array(
                        'video_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/step_intro.mp4'),
                        'poster_link' => '',
                        'icon' => esc_attr('twbb-no-icon'),
                        'title' => esc_html__('10Web Builder Editor tour', 'tenweb-builder'),
                        'description' => wp_kses_post(__('Explore our drag-and-drop editor’s powerful <br>features that simplify website creation.', 'tenweb-builder') ),
                        'buttons' => array(
                            'class' => esc_attr('twbb-tour-guide__buttons twbb-tour-guide-column'),
                            'buttonLeft' => array(
                                'text' => esc_html__('Remind me later', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_no_bg twbb-tour-guide__button-stop'),
                            ),
                            'buttonRight' => array(
                                'text' => esc_html__('Let’s get started!', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_medium twbb-tour-guide__button_black twbb-tour-guide__button-next twbb-start_tour-send-ga'),
                            ),
                        ),
                        'actionFunction' => 'getStarted',
                    ),
                    '1' => array(
                        'video_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/step_text_editor.mp4'),
                        'poster_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/poster_text_editor.jpg'),
                        'icon' => esc_attr('quick_edit'),
                        'title' => esc_html__('Quick edit', 'tenweb-builder'),
                        'description' => wp_kses_post(__('Easily customize the text and styles <br>of the selected section.', 'tenweb-builder') ),
                        'buttons' => array(
                            'class' => esc_attr('twbb-tour-guide__buttons twbb-tour-guide-row'),
                            'buttonLeft' => array(
                                'text' => '',
                                'classes' => esc_attr('twbb-button-invisible'),
                            ),
                            'buttonRight' => array(
                                'text' => esc_html__('Next Step', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_black twbb-tour-guide__button-next'),
                            ),
                        ),
                        'actionFunction' => 'quickEdit',
                    ),
                    '2' => array(
                        'video_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/step_container.mp4'),
                        'poster_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/poster_container.jpg'),
                        'icon' => esc_attr('container_section'),
                        'title' => esc_html__('Use containers', 'tenweb-builder'),
                        'description' => wp_kses_post(__('Use containers to create new sections<br> and make editing more flexible', 'tenweb-builder') ),
                        'buttons' => array(
                            'class' => esc_attr('twbb-tour-guide__buttons twbb-tour-guide-row'),
                            'buttonLeft' => array(
                                'text' => esc_html__('Back', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_grey twbb-tour-guide__button-back'),
                            ),
                            'buttonRight' => array(
                                'text' => esc_html__('Next', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_black twbb-tour-guide__button-next'),
                            ),
                        ),
                        'actionFunction' => 'containerSection',
                    ),
                    '3' => array(
                        'video_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/step_container_openned.mp4'),
                        'poster_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/poster_container_openned.jpg'),
                        'icon' => esc_attr('visual_element'),
                        'title' => esc_html__('Add a new visual element', 'tenweb-builder'),
                        'description' => wp_kses_post(__('Add a new visual element using a variety of <br>widgets. Simply drag and drop the widgets <br>to the desired location.', 'tenweb-builder') ),
                        'buttons' => array(
                            'class' => esc_attr('twbb-tour-guide__buttons twbb-tour-guide-row'),
                            'buttonLeft' => array(
                                'text' => esc_html__('Back', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_grey twbb-tour-guide__button-back'),
                            ),
                            'buttonRight' => array(
                                'text' => esc_html__('Next', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_black twbb-tour-guide__button-next'),
                            ),
                        ),
                        'actionFunction' => 'visualElement',
                    ),
                    '4' => array(
                        'video_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/step_responsiveness.mp4'),
                        'poster_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/poster_responsiveness.jpg'),
                        'icon' => esc_attr('responsiveness'),
                        'title' => esc_html__('Edit any page and check responsiveness', 'tenweb-builder'),
                        'description' => wp_kses_post(__('Switch to edit or add pages on your <br>website and quickly check their <br>responsiveness.', 'tenweb-builder') ),
                        'buttons' => array(
                            'class' => esc_attr('twbb-tour-guide__buttons twbb-tour-guide-row'),
                            'buttonLeft' => array(
                                'text' => esc_html__('Back', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_grey twbb-tour-guide__button-back'),
                            ),
                            'buttonRight' => array(
                                'text' => esc_html__('Next', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_black twbb-tour-guide__button-next'),
                            ),
                        ),
                        'actionFunction' => 'responsiveness',
                    ),
                    '5' => array(
                        'video_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/step_themes.mp4'),
                        'poster_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/poster_themes.jpg'),
                        'icon' => esc_attr('global_styles'),
                        'title' => esc_html__('Change Global Styles and Settings', 'tenweb-builder'),
                        'description' => wp_kses_post(__('Easily change the entire website’s colors <br>and fonts all at once.', 'tenweb-builder') ),
                        'buttons' => array(
                            'class' => esc_attr('twbb-tour-guide__buttons twbb-tour-guide-row'),
                            'buttonLeft' => array(
                                'text' => esc_html__('Back', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_grey twbb-tour-guide__button-back'),
                            ),
                            'buttonRight' => array(
                                'text' => esc_html__('Next', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_black twbb-tour-guide__button-next'),
                            ),
                        ),
                        'actionFunction' => 'globalStyles',
                    ),
                    '6' => array(
                        'video_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/step_publish.mp4'),
                        'poster_link' => esc_url(TWBB_URL . '/assets/images/tour_assets/poster_publish.jpg'),
                        'icon' => esc_attr('publish_website'),
                        'title' => esc_html__('Publish your website', 'tenweb-builder'),
                        'description' => wp_kses_post(__('Publish your changes and see it live.<br>You can always save your changes as<br>a draft to edit them later.', 'tenweb-builder') ),
                        'buttons' => array(
                            'class' => esc_attr('twbb-tour-guide__buttons twbb-tour-guide-row'),
                            'buttonLeft' => array(
                                'text' => esc_html__('Back', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_grey twbb-tour-guide__button-back'),
                            ),
                            'buttonRight' => array(
                                'text' => esc_html__('Done', 'tenweb-builder'),
                                'classes' => esc_attr('twbb-tour-guide__button_small twbb-tour-guide__button_black twbb-tour-guide__button-done'),
                            ),
                        ),
                        'actionFunction' => 'publishWebsite',
                    ),
                );
                wp_localize_script( 'twbb-editor-tour-script','tour_data', array(
                        'tour_status' => get_option('twbb_tour_status'),
                        'ajaxurl'     => admin_url( 'admin-ajax.php' ),
                        'nonce'       => wp_create_nonce( 'twbb' ),
                        'tour_content_variables' => $tour_content_variables,
                ) );
            }
        }
        else {
            wp_enqueue_style( 'twbb-editor_v1', TWBB_URL . '/assets/editor/css/editor_v1.css', array(), TWBB_VERSION );
        }
        $is_ai_plan = in_array(self::checkManagerExistence()['subscription_id'], TW_AI_PLAN_IDS ) ? '1' : '0';
        $is_profesional_plan = in_array(self::checkManagerExistence()['subscription_id'], TW_PROFFESIONAL_IDS ) ? '1' : '0';
        $show_tour = is_array(get_option("twbb_imported_site_data_generated")) &&
            ( get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_regenerate' ||
                get_option("twbb_imported_site_data_generated")['import_type'] == 'ai_recreate' );
        $localizedArrayOptions = array(
            'ajaxurl'              => admin_url( 'admin-ajax.php' ),
            'nonce'                => wp_create_nonce( 'twbb' ),
            'loaded_templates'     => Templates::get_instance()->get_loaded_templates(),
            'rest_route'           => $rest_route,
            'rest_nonce'           => wp_create_nonce( 'wp_rest' ),
            'post_id'              => get_the_ID(),
            'edit_button_title'    => __( 'Edit Template', 'tenweb-builder' ),
            'teplate_popup_title'  => __( 'Choose templates for your web site', 'tenweb-builder' ),
            'current_page'         => __( 'Current Page', 'tenweb-builder' ),
            'entire_site'          => __( 'Entire Site', 'tenweb-builder' ),
            'singular'             => __( 'Singular', 'tenweb-builder' ),
            'archive'              => __( 'Archive', 'tenweb-builder' ),
            'choose'               => __( 'Choose', 'tenweb-builder' ),
            'template'             => __( 'template', 'tenweb-builder' ),
            'twbb_page_type'       => Condition::get_instance()->get_page_type(),
            'edit'                 => __( 'Edit', 'tenweb-builder' ),
            'edit_localy'          => __( 'Edit Locally', 'tenweb-builder' ),
            'edit_url'             => $edit_url,
            'edit_local_url'       => add_query_arg( array( 'action' => 'popup_template_ajax' ), admin_url( 'admin-ajax.php' ) ),
            'popup_template_draw'  => add_query_arg( array( 'action' => 'draw_popup' ), admin_url( 'admin-ajax.php' ) ),
            'page_title'           => get_the_title(),
            'is_post_template'     => $is_post_template,
            'header_button'        => $header_button,
            'plugin_url'           => plugin_dir_url( __FILE__ ),
            'remove_template_ajax' => add_query_arg( array( 'action' => 'remove_template_ajax' ), admin_url( 'admin-ajax.php' ) ),
            'twbb_header'          => __( 'Edit Header Template', 'tenweb-builder' ),
            'twbb_footer'          => __( 'Edit Footer Template', 'tenweb-builder' ),
            'twbb_single'          => __( 'Edit Single Template', 'tenweb-builder' ),
            'twbb_archive'         => __( 'Edit Archive Template', 'tenweb-builder' ),
            'twbb_template_type'   => $twbb_template_type,
            'editor_v2'           => $this->editorVersion2,
            'dashboard_url'       => esc_url( self::checkManagerExistence()['dashboard_url'] ),
            'wp_dashboard_url'    => esc_url(get_dashboard_url()),
            'dashboard_text'         => __( '10Web Dashboard', 'tenweb-builder' ),
            'request_developer_text'         => __( 'Request a developer', 'tenweb-builder' ),
            'request_developer_url'         => esc_url( TENWEB_DASHBOARD . '/websites/' . get_option('tenweb_domain_id') . '/professional' ),
            'builder_plugin_name'         => __( '10Web Builder', 'tenweb-builder' ),
            'display_conditions_text'         => __( 'Display Conditions', 'tenweb-builder' ),
            'is_tenweb_hosted' => TW_HOSTED_ON_10WEB,
            'is_ai_plan' => $is_ai_plan,
            'is_profesional_plan' => $is_profesional_plan,
            'twbb_imported_kit_ids' => get_option( 'twbb_imported_kit_ids' ),
            'twbb_imported_kit_typo_ids' => get_option( 'twbb_imported_kit_typo_ids' ),
            'add_page_link' => esc_url(add_query_arg(array('add_page' => 1), self::checkManagerExistence()['dashboard_url'])),
            'track_publish_ajax'  => add_query_arg( array( 'action' => 'track_publish_ajax' ), admin_url( 'admin-ajax.php' ) ),
            'track_publish_button'=> get_option("twbb_track_publish_button"),
            'tour_status' => get_option('twbb_tour_status'),
            'show_tour' => $show_tour,
        );
		wp_localize_script( 'twbb-editor-scripts', 'twbb_options', $localizedArrayOptions );
		wp_localize_script( 'twbb-editor-scripts-v2', 'twbb_options', $localizedArrayOptions );
		wp_localize_script( 'twbb-editor-kit-themes-script', 'twbb_options', $localizedArrayOptions );
		do_action( 'twbb_after_enqueue_scripts' );
		do_action( 'twbb_before_enqueue_editor_scripts' );
	}

	public function admin_enqueue_scripts() {
		wp_enqueue_script( TWBB_PREFIX . '-admin-script', TWBB_URL . '/assets/admin/js/admin.js', [ 'jquery' ], TWBB_VERSION, TRUE );
		wp_localize_script( TWBB_PREFIX . '-admin-script', 'twbb_admin',
		                    array(
			                    'ajax_url' => wp_nonce_url( admin_url( 'admin-ajax.php' ), 'twbb_remove_template_ajax', 'twbb_nonce' ),
		                    ) );
		wp_enqueue_style( TWBB_PREFIX . '-admin-style', TWBB_URL . '/assets/admin/css/admin.css', [], TWBB_VERSION );
	}

	public function elementor_compatibility_notice() {
		$elementor_notice = NULL;
		add_thickbox();
		$thickbox          = add_query_arg(
			array( 'tab' => 'plugin-information', 'plugin' => 'elementor', 'TB_iframe' => 'true' ),
			admin_url( 'plugin-install.php' )
		);
		$link              = "";
		$installed_plugins = get_plugins();
		if ( ! isset( $installed_plugins[ 'elementor/elementor.php' ] ) ) {
			$elementor_notice = __( '10Web Builder requires Elementor plugin. Please install and activate the latest version of %s plugin.', 'tenweb-builder' );
			if ( isset( $_GET[ 'from' ] ) && '10web' == $_GET[ 'from' ] ) {
				$link   = 'thickbox';
				$script = '<script>jQuery(window).load(function() {jQuery("#twbb_install_elementor").trigger("click")});</script>';
			} else {
				$link = add_query_arg(
					array( 's' => 'elementor', 'tab' => 'search', 'type' => 'term', 'from' => '10web' ),
					admin_url( 'plugin-install.php' )
				);
			}
		} else if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
			$elementor_notice = __( '10Web Builder requires Elementor plugin. Please activate %s plugin.', 'tenweb-builder' );
			$link             = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=elementor/elementor.php&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_elementor/elementor.php' );
		} else if ( version_compare( ELEMENTOR_VERSION, TWBB_ELEMENTOR_MIN_VERSION, '<' ) ) {
			$elementor_notice = __( '10Web Builder requires latest version of Elementor plugin. Please update %s plugin.', 'tenweb-builder' );
			$link             = 'thickbox';
		}
		if ( $elementor_notice !== NULL ) {

			if ( current_user_can( 'activate_plugins' ) ) {

				if ( $link == 'thickbox' ) {
					$link = '<a id="twbb_install_elementor" class="thickbox" href="' . $thickbox . '">Elementor</a>';
				} else {
					$link = '<a href="' . $link . '">Elementor</a>';
				}
			} else {
				$link = 'Elementor';
			}
			echo '<div class="error twbb_notice">' . sprintf( $elementor_notice, $link ) . "</div>";
			if ( isset( $script ) ) {
				echo $script;
			}
		}
	}

      public function changeSaveKitOptions() {
          $new_kit = $_POST['kit_options'];
          if ( isset($_POST['kit_options']) && wp_verify_nonce($_POST['nonce'], 'twbb') ) {
              $active_kit = \Elementor\Plugin::instance()->kits_manager->get_active_kit();
              $active_kit_id = (int)$active_kit->get_id();
              $old_settings = $active_kit->get_meta(PageManager::META_KEY);

              $new_site_settings = array(
                  'system_colors' => array(),
                  'custom_colors' => array(),
                  'system_typography' => array(),
                  'custom_typography' => array(),
              );

              if (isset($old_settings)) {

                  foreach ($old_settings['custom_colors'] as $newMeta) {
                      if (isset($new_kit['custom_colors'][$newMeta['_id']])) {
                          $new_site_settings['custom_colors'][] = [
                              '_id' => $newMeta['_id'],
                              'title' => $newMeta['title'],
                              'color' => $new_kit['custom_colors'][$newMeta['_id']]['color'],
                          ];
                          unset($new_kit['custom_colors'][$newMeta['_id']]);
                      }
                  }
                  //revert deleted Kit Item
                  if ( count($new_kit['custom_colors']) > 0 ) {
                      foreach ($new_kit['custom_colors'] as $id => $each_kit_item ) {
                          $new_site_settings['custom_colors'][] = [
                              '_id' => $id,
                              'title' => $each_kit_item['title'],
                              'color' => $each_kit_item['color'],
                          ];
                      }
                  }
                  foreach ($old_settings['system_colors'] as $newMeta) {
                      if (isset($new_kit['system_colors'][$newMeta['_id']])) {
                          $new_site_settings['system_colors'][] = [
                              '_id' => $newMeta['_id'],
                              'title' => $newMeta['title'],
                              'color' => $new_kit['system_colors'][$newMeta['_id']]['color'],
                          ];
                          unset($new_kit['system_colors'][$newMeta['_id']]);
                      }
                  }
                  //revert deleted Kit Item
                  if ( count($new_kit['system_colors']) > 0 ) {
                      foreach ($new_kit['system_colors'] as $id => $each_kit_item ) {
                          $new_site_settings['system_colors'][] = [
                              '_id' => $id,
                              'title' => $each_kit_item['title'],
                              'color' => $each_kit_item['color'],
                          ];
                      }
                  }

                  $new_site_settings['system_typography'] = $old_settings['system_typography'];
                  foreach ($new_site_settings['system_typography'] as $key => $newMeta) {
                      // change font family for all typographies
                      $new_site_settings['system_typography'][$key]['typography_font_family'] = $new_kit['font_family'];
                  }

                  $new_site_settings['custom_typography'] = $old_settings['custom_typography'];
                  foreach ($new_site_settings['custom_typography'] as $key => $newMeta) {
                      // change font family for all typographies
                      $new_site_settings['custom_typography'][$key]['typography_font_family'] = $new_kit['font_family'];
                  }

                  $new_site_settings = array_replace_recursive($old_settings, $new_site_settings);

                  update_post_meta($active_kit_id, '_elementor_page_settings', $new_site_settings);
                  \Elementor\Plugin::instance()->files_manager->clear_cache();
                  return wp_send_json_success(['status' => 'success']);
              }
          }
          return wp_send_json_error(['status' => 'Something went wrong.']);
      }

      public function updateTourStatus() {
          if ( isset($_POST['tour_status']) && wp_verify_nonce($_POST['nonce'], 'twbb') ) {
              update_option('twbb_tour_status', $_POST['tour_status'] );
              wp_send_json_success();
          }
          wp_send_json_error();
      }


      private function set_redirect_for_first_visit(){
        // refresh elementor editor page if user opens it after upgrade first time to avoid loading issues
        // elementor shows safe mode button
        add_action('elementor/editor/init', function(){
          add_action('wp_footer', [$this, 'redirect_if_first_visit'], 1);
        }, 1);

        add_action('admin_print_footer_scripts', [$this, 'redirect_if_first_visit'], 1);
      }

      public function redirect_if_first_visit(){
        if(!empty($_GET['tenweb_wp_login_token']) && isset($_GET['action']) && $_GET['action'] === 'elementor' && is_user_logged_in()){
          echo '<script>
                    let url = new URL(window.location.href);
                    url["searchParams"].delete("tenweb_wp_login_token");
                    url["searchParams"].delete("email");
                    window.location.href = url;
                </script>';
          die();
        }
      }

}

