jQuery(document).ready(function () {
    // add 10Web themes icon to menu
    jQuery('#elementor-editor-wrapper-v2 .MuiGrid-root:nth-child(1) div:nth-child(3)').append(
        '<span class="twbb-kit-themes-button" id="twbb-kit-themes-button"></span>');
    jQuery('.twbb-kit-themes-button').on('click',function(event) {
        event.stopPropagation();
        if (event.target !== event.currentTarget) {
            return;
        }
        jQuery(this).addClass('kit-themes-pressed');
        if (!jQuery('.twbb-kit-themes-button .twbb-kit-themes-container').length) {
            if ( jQuery('#elementor-panel-header-kit-close').is(":visible") && !jQuery(this).hasClass('twbb-theme-tour')) {
                jQuery('#elementor-panel-header-kit-close').trigger('click');
            }
            addThemesMenu(jQuery(this));
            jQuery('.twbb-kit-themes-button .twbb-kit-themes-container').show();
        } else if (event.target.id === 'twbb-kit-themes-button') {
            removeThemesPopup();
        }
        analyticsDataPush ( '10Web Styles', '10Web Styles' );
    });

    jQuery("iframe").on("load", function(){
        if (jQuery('.twbb-tour-main-overlay.twbb-tour-guide').css('display') == 'none') {
            jQuery('#elementor-preview-iframe').contents().on("mousedown, mouseup, click", function () {
                removeThemesPopup();
            });
        }
    });
    jQuery(window).on('click', function() {
        if (jQuery('.twbb-tour-main-overlay.twbb-tour-guide').css('display') == 'none') {
            removeThemesPopup();
        }
    });
});


function addThemesMenu(parent) {
    let kitThemesMenu = jQuery('#elementor-preview-iframe').contents().find('.twbb-kit-themes-container').clone();
    parent.append( kitThemesMenu );
    //jQuery('.twbb-kit-themes-button').parent().find('.MuiBox-root .MuiToggleButton-root').attr('aria-pressed', 'false').removeClass('Mui-selected');
    jQuery('.twbb-kit-themes-button').addClass('kit-themes-pressed');
    let selected_kit = jQuery('.twbb-kit-themes-button').attr('selected-kit');
    if ( selected_kit !== undefined ) {
        jQuery('.' + selected_kit).addClass('twbb-kit-theme-selected');
    }
}
function kitThemeChanges(that) {
    if ( jQuery('.twbb-kit-themes-save-button').hasClass('disabled') ) {
        jQuery('.twbb-kit-themes-save-button').removeClass('disabled')
    }
    jQuery('.twbb-kit-each-theme').removeClass('twbb-kit-theme-selected');
    jQuery(that).addClass('twbb-kit-theme-selected');

    let themeCSS = generateKitCSS()['themeCSS'];

    jQuery('#elementor-preview-iframe').contents().find('body').css(themeCSS);
}

function generateKitCSS() {
    let selectedKit = jQuery('.twbb-kit-theme-selected');
    let kit_info = selectedKit.data('kit-info');
    if ( kit_info === undefined ) {
        return false;
    }
    let kit = {
        'system_colors': {},
        'custom_colors': {},
        'custom_typography': {},
    };
    kit['system_colors'] = {
        'primary': { 'title': 'Title Dark', 'color': kit_info['system_colors']['Title dark']['color'] },
        'secondary': { 'title': 'Secondary', 'color': kit_info['system_colors']['Secondary']['color'] },
        'text': { 'title': 'Description text dark', 'color': kit_info['system_colors']['Description text dark']['color'] },
        'accent': { 'title': 'Accent', 'color': kit_info['system_colors']['Accent']['color'] },
    }
    kit['font_family'] = kit_info['font_family'];
    let themeCSS = {
        '--e-global-typography-primary-font-family': kit_info['font_family'],
        '--e-global-typography-secondary-font-family': kit_info['font_family'],
        '--e-global-typography-text-font-family': kit_info['font_family'],
        '--e-global-typography-accent-font-family': kit_info['font_family'],
        '--e-global-color-accent': kit_info['system_colors']['Accent']['color'],
        '--e-global-color-secondary': kit_info['system_colors']['Secondary']['color'],
        '--e-global-color-primary': kit_info['system_colors']['Title dark']['color'],
        '--e-global-color-text': kit_info['system_colors']['Description text dark']['color'],
    };
    jQuery.each( kit_info['custom_colors'], function(key){
        let kit_ids = twbb_options.twbb_imported_kit_ids;
        if ( kit_ids.length != 0 ) {
            themeCSS['--e-global-color-' + kit_ids[key]] = kit_info['custom_colors'][key]['color'];
            kit['custom_colors'][kit_ids[key]] = { 'title': key, 'color':  kit_info['custom_colors'][key]['color'] };
        }
    });

    let kit_typo_ids = twbb_options.twbb_imported_kit_typo_ids;
    if ( kit_typo_ids.length != 0 ) {
        jQuery.each(kit_typo_ids, function (key) {
            themeCSS['--e-global-typography-' + kit_typo_ids[key] + '-font-family'] = kit_info['font_family'];
            kit['custom_typography'][kit_typo_ids[key]] = { 'title': key, 'font-family':  kit_info['font_family'] };

        });
    }

    return {'kit':kit,'themeCSS':themeCSS};

}

function saveThemeKit() {
    let theme = jQuery('.twbb-kit-theme-selected').data('kit-name').replace('twbb-kit-theme-', '');
    analyticsDataPush ( 'Save changes', '10Web Styles',  theme );
    jQuery('body').append(saveThemePopup());
}

function saveThemeChanges() {
    let theme = jQuery('.twbb-kit-theme-selected').data('kit-name').replace('twbb-kit-theme-', '');
    analyticsDataPush ( 'Save from popup', '10Web Styles', theme );
    jQuery('.twbb-theme-popup-save-button').text('').append('<span class="twbb-themes-save-loader">' +
        '<i class="fa fa-spin fa-circle-o-notch" aria-hidden="true"></i>' +
        '</span>');
    let kit = generateKitCSS()['kit'];
    if ( kit !== 'undefined' ) {
        jQuery.ajax({
            type: 'POST',
            url: twbb_options.ajaxurl,
            dataType: 'json',
            data: {
                'kit_options': kit,
                action: "twbb_change_and_save_kit_options",
                nonce: twbb_options.nonce,
            }
        }).success(function(res){
            if( res.data['status'] === 'success' ) {
                jQuery('.twbb-kit-themes-button').attr('selected-kit', jQuery('.twbb-kit-theme-selected').data('kit-name'));
                removeThemesPopup();
                jQuery('#elementor-editor-wrapper-v2 .MuiGrid-root:nth-child(1) div:nth-child(3) span:nth-child(2) button[value="Site Settings"]').trigger('click');
            }
        }).error(function () {
            jQuery('.twbb-theme-popup-save-button').text('Save');
            jQuery('.twbb-theme-popup-save-button .twbb-themes-save-loader').remove();
        });
    } else {
        console.log('There is no defined kit');
        removeThemesPopup();
    }
}

function removeThemesPopup() {
    if ( jQuery('.twbb-kit-theme-selected').length > 0 ) {
        let theme = jQuery('.twbb-kit-theme-selected').data('kit-name').replace('twbb-kit-theme-', '');
        analyticsDataPush('Cancel or Close popup', '10Web Styles', theme);
    }
    jQuery('.twbb-kit-themes-button .twbb-kit-themes-container').remove();
    jQuery('#elementor-preview-iframe').contents().find('body').removeAttr("style");
    jQuery('.twbb-kit-themes-button').removeClass('kit-themes-pressed');
    if ( jQuery('.twbb-editor-popup-overlay').length > 0 ) {
        jQuery('.twbb-editor-popup-overlay').remove();
    }
}

function saveThemePopup() {
     let saveThemePopup = '' +
         '<div class="twbb-editor-popup-overlay">' +
         '<div class="twbb-editor-popup-container">' +
            '<span class="twbb-editor-popup-close" onclick="removeThemesPopup()"></span>' +
            '<div class="twbb-theme-popup-title">Save Theme</div>' +
            '<div class="twbb-theme-popup-description">The selected theme will change Global Styles and Fonts, <br>impacting the entire website.</div>' +
            '<div class="twbb-theme-popup-info">If you’ve manually deleted any global style or font, this action won’t restore them.</div>' +
            '<div class="twbb-theme-popup-buttons-container">' +
                '<div class="twbb-theme-popup-button twbb-theme-popup-cancel-button" onclick="removeThemesPopup()">Cancel</div> ' +
                '<div class="twbb-theme-popup-button twbb-theme-popup-save-button" onclick="saveThemeChanges()">Save</div> ' +
            '</div>' +
         '</div>' +
         '</div>';

     return saveThemePopup;
}