class TWBHELP {
    constructor() {
        this.model = {};
    }
    init() {
        let self = this;

        elementor.hooks.addAction( 'panel/open_editor/widget', function( panel, model, view ) {
            self.model = model;
            self.editor_help_click_event();
        });
    }

    /* Help click event from editor widgets area icon click */
    editor_help_click_event() {
        let self = this;
        if ( typeof window.voiceflow != "undefined") {
            jQuery(document).find("#elementor-panel__editor__help__link").off('click');
            jQuery(document).find("#elementor-panel__editor__help__link").on("click", function (event) {
                event.preventDefault();
                window.voiceflow.chat.show();
                window.voiceflow.chat.open();

                //widgets which name's need to change
                var widgetType = self.model.attributes.widgetType;
                widgetType = widgetType.replace(/twbb_/g,'');
                widgetType = widgetType.replace(/twbb-/g,'');
                widgetType = widgetType.replace(/twbb/g,'');
                console.log("Ways to use " + widgetType + " widget");
                window.voiceflow.chat.interact({
                    type: "text",
                    payload: "Ways to use " + widgetType + " widget"
                })

                analyticsDataPush ( 'Left Menu', 'Need Help', widgetType );

            });
            jQuery(document).find("#elementor-panel__editor__help__link").attr("href", "#");
        }
    }
}

let twbHelpOb;

if ( twbb_fe_localized_data.is_1wf === 'true' ) {
    jQuery(window).on('elementor:loaded', function () {
        (function (d, t) {
            var v = d.createElement(t), s = d.getElementsByTagName(t)[0];
            v.onload = function () {
                window.voiceflow.chat.load({
                    verify: {projectID: '65118122ab3cff00089f71f1'},
                    url: 'https://general-runtime.voiceflow.com',
                    versionID: 'production',
                    user: {
                        name: twbb_fe_localized_data.name + ' (' + twbb_fe_localized_data.clients_id + ')',
                    },
                    userID: twbb_fe_localized_data.clients_id
                }).then(() => {
                    window.voiceflow.chat.hide();
                });
            }
            v.src = "https://cdn.voiceflow.com/widget/bundle.mjs";
            v.type = "text/javascript";
            s.parentNode.insertBefore(v, s);
        })(document, 'script');

        twbHelpOb = new TWBHELP();
        twbHelpOb.init();

        jQuery(document).on('click', "a[aria-label='Help']", function (e) {
            e.preventDefault();
            if (typeof window.voiceflow != "undefined") {
                window.voiceflow.chat.show();
                window.voiceflow.chat.open();
                analyticsDataPush('Top Bar', 'Need Help');
            }
        })
    });
}