class WriteWithAIHelper {

    static getCacheElements() {
        let cache = {};
        cache.controls = [
            "text",
            "description_text",
            "editor",
            "title",
            "title_text",
            "tab_title",
            "tab_content",
            "inner_text",
            "testimonial_content",
            "testimonial_name",
            "testimonial_job",
            "testimonial_image",
            "alert_title",
            "alert_description",
            "link_text",
            "prefix",
            "suffix",
            "image",
        ];
        cache.sub_controls = [
            "tabs",
            "icon_list",
            "social_icon_list",
            "slides",
        ];
        cache.coming_soon_controls = [
            "selected_icon",
            "social_icon",
            "selected_active_icon",
            "dismiss_icon",
            "custom_css",
            "html",
        ];

        return cache;
    }

    static validateOutput(output, widgetType) {
        /* Remove first and last ', " if present */
        if((output.charAt(0) == "'" && output.charAt(output.length - 1)  == "'") ||
            (output.charAt(0) == '"' && output.charAt(output.length - 1)  == '"')) {
            output = output.slice(1, -1);
        }

        /* Remove last . if present for heading widget*/
        if(widgetType == 'title' && output.charAt(output.length - 1)  == ".") {
            output = output.slice(0, -1);
        }
        return output;
    }
}