<?php

namespace Tenweb_Builder\FastEditor\Tools;

class MoreTool extends FastEditorTool
{
    public function getToolContent() {
        $more_html = '';
        if( $this->visibilityCheck() ) {
            $more_html = "<div class='twbb-more-tool-container twbb-fe-tool' data-tool='more'>
<div class='twbb-fet-tooltip'>" . __('More', 'tenweb-builder') . "</div>
<span class='twbb-more-tool' data-analytics='More'><img src='".
                TWBB_URL . '/assets/editor/images/FastEditor/fe-more.svg' . "'></span></div>";
        }
        return $more_html;
    }

    public function editorScripts() {
        wp_enqueue_style('twbb-more-tool-editor-style', TWBB_URL . '/assets/editor/css/FastEditor/more-tool_editor.css', array(), TWBB_VERSION);
    }

    public function frontendScripts() {
        wp_enqueue_script('twbb-more-tool-frontend-script', TWBB_URL . '/assets/editor/js/FastEditor/more-tool_frontend.js', ['jquery', 'twbb-fe-tool-script'], TWBB_VERSION, TRUE);
    }
    public function frontendStyles() {}

}