<?php

namespace Tenweb_Builder\FastEditor\Tools;
class HelpChatTool extends FastEditorTool
{
    private $userInfo;

    public function __construct() {
        $this->setUserInfo();
    }

    public function getToolContent() {
        $help_chat_html = '';
        if( $this->visibilityCheck() ) {
            $help_chat_html = "<div class='twbb-fe-tool twbb-fe-right-border twb-help-button-layer' data-tool='help_chat'><span class='twb-help-button'><span class='twbb-hide-in-hover'>" . __('Help', 'tenweb-builder') . "</span></span></div>";
        }
        return $help_chat_html;
    }

    public function editorScripts() {
        wp_enqueue_script('twbb-help-chat-editor', TWBB_URL . '/assets/editor/js/FastEditor/help-chat_editor.js', ['jquery','twbb-fe-helper-script'], TWBB_VERSION, TRUE);
    }

    public function frontendScripts() {
        wp_enqueue_script('twbb-help-chat-frontend-script', TWBB_URL . '/assets/editor/js/FastEditor/help-chat_frontend.js', ['jquery','twbb-fe-helper-script'], TWBB_VERSION, TRUE);
    }
    public function frontendStyles() {
        wp_enqueue_style( 'twbb-help-chat-frontend-style', TWBB_URL . '/assets/editor/css/FastEditor/help-chat_frontend.css', array(), TWBB_VERSION );
    }

    protected function visibilityCheck()
    {
        if ( !empty($this->userInfo) ) {
            if ( is_array($this->userInfo) && isset($this->userInfo['agreement_info'] ) ) {
                if ( is_array($this->userInfo['agreement_info'])
                    && isset($this->userInfo['agreement_info']['coupon_code'])
                    && $this->userInfo['agreement_info']['coupon_code'] == '1wf' ) {
                    return true;
                }
            }
        }
        return false;
    }

    public function getLocalizedData() {
        $clients_id = '';
        $name = 'Client';
        if ( isset($this->userInfo['agreement_info']['clients_id']) ) {
            $clients_id = $this->userInfo['agreement_info']['clients_id'];
        }
        if ( isset($this->userInfo['client_info']['name']) ) {
            $name = $this->userInfo['client_info']['name'];
        }
        $is_1wf = $this->visibilityCheck() ? 'true' : 'false';
        $localized_data =  array(
            'clients_id'  => esc_html($clients_id),
            'name'  => esc_html($name),
            'is_1wf' => $is_1wf,
        );
        return $localized_data;
    }

    protected function setUserInfo() {
        $this->userInfo = array();
        if ( class_exists( '\Tenweb_Manager\Manager' ) ) {
            $this->userInfo = \Tenweb_Manager\Helper::get_tenweb_user_info();
        }
    }
}