<?php

namespace Tenweb_Builder\FastEditor\Tools;

class ChoiceTypeTool extends FastEditorTool
{

    public function getToolContent() {
        $choice_type_tool_html = '';
        if( $this->visibilityCheck() ) {
            $tooltipClass = !empty($this->controlData[0]['tool']) ? " twbb-fet-tooltip-".$this->controlData[0]['tool'] : '';
            $choice_type_tool_html = "
                <div class='twbb-choice-tool-container twbb-fe-onedit-tool twbb-fe-right-border'
                 data-control='" . esc_attr($this->controlName) . "' 
                 data-tool='" . esc_attr($this->controlData[0]['tool']) . "' 
                 data-analytics='" . esc_attr($this->controlData[0]['analytics']) . "'>";
            $choice_type_tool_html .= "<div class='twbb-fet-tooltip".$tooltipClass."'>" . esc_attr($this->tooltip) . "</div>";
            foreach ( $this->controlData[0]['options'] as $key => $value ) {
                $choice_type_tool_html .= " <span class='twbb-choice-tool' onclick='twbb_onToolClick(this,\"choice_tool\")' data-tool-value='" . esc_attr($value) . "'>
                        <img src='". TWBB_URL . '/assets/editor/images/FastEditor/' . $key . '.svg' . "'>
                    </span>";
            }
            $choice_type_tool_html .= "</div>";
        }
        return $choice_type_tool_html;
    }

    public function editorScripts() {}

    public function frontendScripts() {
        wp_enqueue_script('twbb-choice-type-tool-script', TWBB_URL . '/assets/editor/js/FastEditor/choice-tool_frontend.js', ['jquery', 'twbb-fe-tool-script'], TWBB_VERSION);
    }
    public function frontendStyles() {
        wp_enqueue_style( 'twbb-choice-type-tool-frontend-style', TWBB_URL . '/assets/editor/css/FastEditor/choice-tool_frontend.css', array(), TWBB_VERSION );
    }

}