<?php
wp_enqueue_style('bootstrap-iv_property-110', wp_iv_property_URLPATH . 'admin/files/css/iv-bootstrap-4.css');
wp_enqueue_style('dirpro_categories_tree', wp_iv_property_URLPATH . 'admin/files/css/dirpro_categories.css');
wp_enqueue_script('category_tree', wp_iv_property_URLPATH . 'admin/files/js/category_tree.js', array('jquery'),"1.0", true);


global $post,$wpdb,$tag;
$directory_url=get_option('_iv_property_url');
if($directory_url==""){$directory_url='property';}
$post_limit='9999';
if(isset($atts['post_limit']) and $atts['post_limit']!="" ){
 $post_limit=$atts['post_limit'];
}
$postcats_arr=array();
if(isset($atts['slugs'])){
		$postcats = $atts['slugs'];
		$postcats_arr=explode(',',$postcats);
}

$dir5_background_color=get_option('dir5_background_color');
	if($dir5_background_color==""){$dir5_background_color='#EBEBEB';}
?>

<style>
	.bootstrap-wrapper, .bg{
	background:<?php echo esc_html($dir5_background_color);?> !important;
	}
</style>
<section id="destination" class="background-transparent">
	<section class="bootstrap-wrapper bg">
		<div class="container py-5">
			<div class="row" id="dirpro_categories_tree">
			<?php
						if( isset($_POST['submit'])){
							$selected = sanitize_text_field($_POST['property-category']);
						}
							//property
							$taxonomy = $directory_url.'-category';
							$args = array(
								'orderby'           => 'name',
								'order'             => 'ASC',
								'hide_empty'        => true,
								'exclude'           => array(),
								'exclude_tree'      => array(),
								'include'           => array(),
								'number'            => $post_limit,
								'fields'            => 'all',
								'slug'              => $postcats_arr,							
								'hierarchical'      => true,
								'child_of'          => 0,
								'childless'         => false,
								'show_count'        => '1',
							);
				$terms = get_terms($taxonomy,$args); // Get all terms of a taxonomy
				if ( $terms && !is_wp_error( $terms ) ) :
						$i=0;
						foreach ( $terms as $term_parent ) {
							if($term_parent->count>0 && $term_parent->parent==0){
							$cat_link= get_term_link($term_parent , $directory_url.'-category');
						?>
							<div class="mb-5 column">
								<div class="dirpro_categories">
									<div class="dirpro_categories_img">
									</div>
									<div class="dirpro_categories_title p-0 m-0">
										<!-- <i class="dirpro_parent_icon far fa-lightbulb"></i> -->
										<img src="<?php echo wp_iv_property_URLPATH."/assets/images/cat.png";?>" alt="" class="dirpro_parent_icon">
										<a href="<?php echo esc_url($cat_link); ?>">
											<?php 
												echo esc_html($term_parent->name);
											?>
										</a>
									</div>
								<?php 
									$parent_term_id = $term_parent->term_id; // term id of parent term
									$taxonomies2 = array( 
										$directory_url.'-category',
									);
									$args2 = array(
										'parent'         => $parent_term_id,
										// 'child_of'      => $parent_term_id, 
									); 
									 $terms2 = get_terms($taxonomies2, $args2);
									foreach ($terms2 as $child) {
										$child_link= get_term_link($child , $directory_url.'-category');
									?>
										<a href="<?php echo esc_url($child_link); ?>" class="sub_cat">
											<span class="sub_name">
												<?php echo $child->name; ?>
											</span>
											<span class="sub_count">
												<?php echo $child->count; ?>
												
											</span>
										</a>
									<?php
									}
							?>
								</div>
							</div>
					<?php
					}								
				}
				endif;
				?>
			</div>
		</div>
	</section>
</section>
<?php
	wp_reset_query();
?>
