<?php

namespace TenWebWooP\WoocommerceWidgets\Filter\Includes\Query\QueryArgs;

class TaxQuery implements QueryArgsInterface {

    private $query_args;

    private $field;

    public function __construct($query_args, $field) {
        $this->query_args = $query_args;
        $this->field = $field;
        $this->setArgs();
    }

    public function setArgs() {
        if (isset($this->field->options)) {
            $options = $this->field->options;
            $args = array();
            $taxonomy = '';

            foreach ($options as $option) {
                if ($option->checked) {
                    $taxonomy = $option->taxonomy;
                    $args[] = $option->slug;
                }
            }

            if (!empty($taxonomy) && !empty($args)) {
                $this->query_args['tax_query'][] = array(
                    'taxonomy' => $taxonomy,
                    'field' => 'slug',
                    'terms' => $args,
                    'operator' => 'IN',
                );
            }
        }
    }

    public function get() {
        return $this->query_args;
    }
}
