<?php

namespace TenWebWooP\WoocommerceWidgets\Filter\Includes;

class Helper {

    public static function getShortNames() {
        $shortNames = array(
            'Checkbox' => 'chk',
            'RadioList' => 'rd',
            'Dropdown' => 'drp',
            'PriceSlider' => 'prc',
            'Box' => 'bx',
            'ColorList' => 'clr',
            'Pillbox' => 'plb'
        );

        return $shortNames;
    }

    public static function getFieldsList() {
        $fieldsList = array(
            'Checkbox' => array(
                'id' => 'Checkbox',
                'title' => 'Checkbox',
                'image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields/checkbox.svg',
                'preview_image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields_preview/checkbox.png',
                'checked' => '',
                'view' => 'checkbox.php'
            ),
            'RadioList' => array(
                'id' => 'RadioList',
                'title' => 'Radio list',
                'image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields/radio_list.svg',
                'preview_image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields_preview/radio_list.png',
                'checked' => '',
                'view' => 'radio_list.php'
            ),
            'Dropdown' => array(
                'id' => 'Dropdown',
                'title' => 'Dropdown',
                'image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields/dropdown.svg',
                'preview_image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields_preview/dropdown.png',
                'checked' => '',
                'view' => 'dropdown.php'
            ),
            'PriceSlider' => array(
                'id' => 'PriceSlider',
                'title' => 'Price slider',
                'image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields/price_slider.svg',
                'preview_image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields_preview/price_slider.png',
                'checked' => '',
                'view' => 'price_slider.php'
            ),
            'Box' => array(
                'id' => 'Box',
                'title' => 'Box',
                'image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields/box.svg',
                'preview_image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields_preview/box.png',
                'checked' => '',
                'view' => 'box.php'
            ),
            'ColorList' => array(
                'id' => 'ColorList',
                'title' => 'Color list',
                'image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields/color_list.svg',
                'preview_image' => array(
                    'color_without_text' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields_preview/color1.png',
                    'color_with_text' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields_preview/color2.png'
                ),
                'checked' => '',
                'view' => 'color_list.php'
            ),
            'Pillbox' => array(
                'id' => 'Pillbox',
                'title' => 'Pillbox',
                'image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields/pillbox.svg',
                'preview_image' => TWW_PRODUCT_FILTER_URL . 'Includes/Admin/assets/images/fields_preview/pillbox.png',
                'checked' => '',
                'view' => 'pillbox.php'
            ),
        );

        return $fieldsList;
    }

    public static function getSources() {
        $sources_list = array(
            array(
                'id' => 'Attribute',
                'title' => 'Variations'
            ),
            array(
                'id' => 'Tag',
                'title' => 'Collections'
            ),
            array(
                'id' => 'Category',
                'title' => 'Categories'
            ),
            array(
                'id' => 'StockStatus',
                'title' => 'Stock Status'
            ),
        );

        return $sources_list;
    }

    public static function getFilters() {
        $filters = get_posts(array( //phpcs:disable WordPressVIPMinimum.Functions.RestrictedFunctions.get_posts_get_posts
            'numberposts' => -1,
            'post_type' => TWW_FILTER_POST_TYPE,
            'post_status' => 'publish'
        ));

        return $filters;
    }

    public static function getTerms() {
        $attributes_list = wc_get_attribute_taxonomies();
        $wc_terms = array();

        foreach ($attributes_list as $attribute) {
            $key = 'pa_' . $attribute->attribute_name;
            $terms = get_terms($key);
            $wc_terms[$key] = $terms;
        }

        return $wc_terms;
    }

    /**
     * Recursive sanitation for an array
     *
     * @param $array
     *
     * @return mixed
     */
    public static function recursiveSanitizeTextField($array) {
        foreach ($array as $key => &$value) {
            if (is_array($value)) {
                $value = self::recursiveSanitizeTextField($value);
            } else {
                $value = sanitize_text_field($value);
            }
        }

        return $array;
    }

    public static function getAnalyticsData() {
        global $wpdb;
        $filters_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $wpdb->posts WHERE `post_status` = 'publish' AND `post_type` = '%s'", TWW_FILTER_POST_TYPE)); //phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $analytics_data = 'cnt:' . $filters_count . ',';
        $fields_data = $wpdb->get_results("SELECT `meta_value` FROM wp_postmeta WHERE meta_key = 'tww_field_data'");  //phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $short_names = \TenWebWooP\WoocommerceWidgets\Filter\Includes\Helper::getShortNames();
        $fields_count = array();

        if (is_array($fields_data)) {
            foreach ($fields_data as $field) {
                if (isset($field->meta_value)) {
                    $field_data = unserialize($field->meta_value); // phpcs:ignore

                    if (!empty($field_data['fieldType'])) {
                        $fieldType = $field_data['fieldType'];

                        if (isset($fields_count[$fieldType])) {
                            ++$fields_count[$fieldType];
                        } else {
                            $fields_count[$fieldType] = 1;
                        }
                    }
                }
            }

            foreach ($fields_count as $name => $count) {
                if (isset($short_names[$name])) {
                    $analytics_data .= $short_names[$name] . ':' . $count . ',';
                }
            }
            $analytics_data = rtrim($analytics_data, ', ');
        }

        return $analytics_data;
    }
}
