<?php
$filter = $context['filter'];
$settings = $context['settings'];
$template_loader = $context['template_loader'];
$template_dir = $context['template_dir'];
$field_uid = 'twwf_filter_' . $filter->id;
$reset_url = '';
/*
 * this is for multisite
 * */
if (isset($_SERVER['HTTP_HOST'], $_SERVER['REQUEST_URI'])) {
    $site_url = '//' . sanitize_text_field($_SERVER['HTTP_HOST']) . sanitize_text_field($_SERVER['REQUEST_URI']);
    $reset_url = remove_query_arg(array('twwf', 'twwf_id', 'twwf_submit', 's1'), $site_url);
}

$tww_reset_button_text = 'Reset';
$tww_filter_button_text = 'Filter';
$twwf_nonce = wp_create_nonce('twwf_nonce');

if (!empty($settings['tww_filter_button_text'])) {
    $tww_filter_button_text = $settings['tww_filter_button_text'];
}

if (!empty($settings['tww_reset_button_text'])) {
    $tww_reset_button_text = $settings['tww_reset_button_text'];
}

?>
<?php if (isset($filter->fields)) { ?>
<form name="tww_filter" id="<?php echo esc_attr($field_uid); ?>" class="tww_filter_form" method="get" action="#<?php echo esc_attr($field_uid); ?>">
    <?php if (!isset($_GET['twwf'])) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended?>
    <?php foreach ($_GET as $key => $val) { // phpcs:ignore ?>
        <input type="hidden" name="<?php echo esc_attr($key); ?>" value="<?php echo esc_attr($val); ?>">
    <?php }?>
    <?php }?>

<div class="twwf_filter_form_fields">
<?php
    if (isset($filter->fields)) {
        $fields = $filter->fields;

        foreach ($fields as $field) {
            if ($field->state === 'on') {
                $template_loader->render_template($field->template . '.php', array(
                    'field' => $field
                ), $template_dir);
            }
        }
    }

?>
</div>
    <div class="twwf_filter_actions">
        <input type="hidden" value="<?php echo esc_attr($twwf_nonce); ?>" name="twwf_nonce">
        <input type="hidden" name="twwf_id" value="<?php echo esc_attr($filter->id); ?>">
        <input type="submit" class="twwf_submit" name="twwf_submit" value="<?php echo esc_attr($tww_filter_button_text); ?>" />
        <?php if (!empty($reset_url)) { ?>
            <a href="<?php echo esc_url($reset_url); ?>" class="twwf_reset_filter"><?php echo esc_html($tww_reset_button_text); ?></a>
        <?php }?>
    </div>
</form>
<script data-two-no-delay="">
    jQuery(document).ready(function () {
        twwf_calculate_form_height();
    });
    function twwf_calculate_form_height(){
        let tww_form_height = jQuery("#<?php echo esc_attr($field_uid); ?>").height();
        if(tww_form_height>749){
            jQuery("#<?php echo esc_attr($field_uid); ?>").addClass('twwf_scrollable');
        }else{
            jQuery("#<?php echo esc_attr($field_uid); ?>").removeClass('twwf_scrollable');
        }
    }


</script>
<?php }?>