<?php

namespace TenWebWooP\WoocommerceWidgets\Filter\Includes\Filter;

use TenWebWooP\WoocommerceWidgets\Filter\Includes\Field\BaseField\BaseField;
use TenWebWooP\WoocommerceWidgets\Filter\Includes\TemplateLoader;

class FilterBuilder implements FilterBuilderInterface {

    private $filter;

    private $default_post_status = 'auto-draft';

    public function __construct($id) {
        $this->init($id);
    }

    private function init($id) {
        $this->filter = new Filter();
        $this->setFilterId($id);
        $this->setFilterName($id);
        $this->setFilterFields($id);
    }

    public function setFilterId($id) {
        $this->filter->id = $id;
    }

    public function setFilterName($id) {
        $post_status = get_post_status($id);

        if ($this->default_post_status === $post_status) {
            $this->filter->name = '';
        } else {
            $this->filter->name = get_the_title($id);
        }
    }

    public function setFilterFields($id) {
        $filter_fields = array();

        if (isset($_GET['twwf_submit'], $_GET['twwf'], $_GET['twwf_id']) && (int) $_GET['twwf_id'] === (int) $id && wp_verify_nonce(sanitize_text_field($_GET['twwf_nonce']), 'twwf_nonce')) { // phpcs:ignore
            $filter_fields = \TenWebWooP\WoocommerceWidgets\Filter\Includes\Helper::recursiveSanitizeTextField($_GET['twwf']); //phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        }
        $field_ids = get_post_meta($id, 'tww_fields', true);

        if (is_array($field_ids) && !empty($field_ids)) {
            global $wpdb;
            $field_ids_imploded = implode(',', array_fill(0, count($field_ids), '%s'));
            $fields_res = $wpdb->get_results($wpdb->prepare("SELECT `meta_value`,`post_id` FROM $wpdb->postmeta WHERE `post_id` IN (" . $field_ids_imploded . ") AND `meta_key` = 'tww_field_data'", $field_ids)); //phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared

            foreach ($fields_res as $res) {
                //todo when we have multiple Price slider in one filter, query dies
                if (!empty($res->meta_value) && !empty($res->post_id)) {
                    $field_data = unserialize($res->meta_value); //phpcs:ignore WordPress.PHP.DiscouragedPHPFunctions.serialize_unserialize
                    $field_id = $res->post_id;
                    $field_data['id'] = $field_id;
                    $field_data['filtered_data'] = array();

                    if (isset($filter_fields[$field_id])) {
                        $field_data['filtered_data'] = $filter_fields[$field_id];
                    }

                    $field_type = $field_data['fieldType'];
                    $field_object_class = '\TenWebWooP\WoocommerceWidgets\Filter\Includes\Field\\' . $field_type . 'Field';

                    if (class_exists($field_object_class)) {
                        $field_object = new $field_object_class($field_data);
                        $field = $field_object->get();

                        if ($field_object instanceof BaseField) {
                            $this->filter->fields[$field->position] = $field;
                        }
                    }
                }
            }

            if (is_array($this->filter->fields)) {
                ksort($this->filter->fields);
            }
        }
    }

    public function getFilter() {
        return $this->filter;
    }

    public function renderFilter($settings = array()) {
        $template_loader = new TemplateLoader();

        if (isset($this->filter)) {
            $template_loader->render_template('filter.php', array(
                'filter' => $this->filter,
                'template_loader' => $template_loader,
                'template_dir' => dirname(__DIR__) . '/Field/Templates',
                'settings' => $settings
            ), dirname(__DIR__) . '/Filter/Templates');
        }
    }
}
