<?php
$field = $context['field'];

if (isset($field->options)) {
    $options = $field->options;
}
$currency = get_woocommerce_currency_symbol();
$field_uid = uniqid('twwf_price_slider');

?>

<?php if (isset($options)) { ?>
    <div class="tww_filter_field_block">
        <div class="twwf_field_header">
            <span class="tww_filter_field_title"><?php echo esc_html($field->name); ?></span>
            <span data-field_id="<?php echo esc_attr($field_uid); ?>" class="twwf_open_close_field"></span>
        </div>
        <div id="<?php echo esc_attr($field_uid); ?>" class="twwf_price_slider_container">
            <div data-currency="<?php echo esc_attr($currency); ?>" data-min="<?php echo esc_attr($options['minPrice']); ?>" data-max="<?php echo esc_attr($options['maxPrice']); ?>" data-min_price="<?php echo esc_attr($field->minPrice); ?>" data-max_price="<?php echo esc_attr($field->maxPrice); ?>" data-step="<?php echo esc_attr($field->step); ?>" class="twwf_price_slider"></div>
            <span class="tww_price_item twwf_min_price"><?php echo esc_html($field->minPrice . $currency); ?></span>
            <span class="tww_price_item twwf_max_price"><?php echo esc_html($field->maxPrice . $currency); ?></span>
            <input class="twwf_min_price_input" type="hidden" name="<?php echo esc_attr($field->inputName); ?>[min]" value="<?php echo esc_attr($options['minPrice']); ?>">
            <input class="twwf_max_price_input" type="hidden" name="<?php echo esc_attr($field->inputName); ?>[max]" value="<?php echo esc_attr($options['maxPrice']); ?>">
        </div>
        <script data-two-no-delay="">
            jQuery( function() {
                let slider = jQuery( '#<?php echo esc_attr($field_uid); ?> .twwf_price_slider' );
                let min_price= parseInt(slider.data('min_price'));
                let max_price= parseInt(slider.data('max_price'));
                let currency= slider.data('currency');
                let step = parseInt(slider.data('step'));
                let values_min_price = parseInt(slider.data('min'))
                let values_max_price = parseInt(slider.data('max'))

                let slider_container = slider.closest('.twwf_price_slider_container');
                let min_price_input = slider_container.find('.twwf_min_price_input');
                let max_price_input = slider_container.find('.twwf_max_price_input');
                slider.slider({
                    range: true,
                    min: min_price,
                    max: max_price,
                    step: step,
                    values: [values_min_price, values_max_price],
                    slide: function (e, ui) {
                        let min = ui.values[0];
                        let max = ui.values[1];
                        min_price_input.val(min);
                        max_price_input.val(max);
                        slider.find('.ui-slider-handle').find('.tww_handle_price').last().find('.price').html(max);
                        slider.find('.ui-slider-handle').find('.tww_handle_price').first().find('.price').html(min);
                    },
                    create: function( event, ui ) {
                        slider.find('.ui-slider-handle').last().html('<span class="tww_handle_price">'+currency+'<span class="price">'+values_max_price+'</span></span>');
                        slider.find('.ui-slider-handle').first().html('<span class="tww_handle_price">'+currency+'<span class="price">'+values_min_price+'</span></span>');
                    }
                });
            } );
        </script>
    </div>
<?php }?>
