<?php
$field = $context['field'];

if (isset($field->options)) {
    $options = $field->options;
}
$field_uid = uniqid('twwf_pillbox_list');
?>

<?php if (isset($options)) { ?>
    <div class="tww_filter_field_block">
        <div class="twwf_field_header">
            <span class="tww_filter_field_title"><?php echo esc_html($field->name); ?></span>
            <span data-field_id="<?php echo esc_attr($field_uid); ?>" class="twwf_open_close_field"></span>
        </div>
        <div id="<?php echo esc_attr($field_uid); ?>" class="twwf_pillbox_list">
            <select style="height:30px;" class="twwf_pillbox_field" multiple="multiple" name="<?php echo esc_attr($field->inputName); ?>">
                <?php foreach ($options as $option) { ?>
                    <?php
                    if (isset($option->fieldState) && $option->fieldState === 'off') {
                        continue;
                    }
                    $selected = '';
                    $u_id = $option->name . '_' . $option->item_id . '_' . $field->id;

                    if (isset($option->checked) && $option->checked) {
                        $selected = 'selected';
                    }
                    ?>
                    <option value="<?php echo esc_attr($option->item_id); ?>" <?php echo esc_attr($selected); ?>><?php echo esc_html($option->name); ?></option>
                <?php }?>
            </select>
        </div>
        <script data-two-no-delay="">
            jQuery(document).ready(function() {
                jQuery('#<?php echo esc_attr($field_uid); ?> .twwf_pillbox_field').select2();
            })
        </script>
    </div>
<?php }?>
