<?php
$field = $context['field'];

if (isset($field->options)) {
    $options = $field->options;
}
$color_style = '';
$view_type = $field->fieldView;
$content_class = 'twwf_horizontal';

if ($view_type === 'color_with_text') {
    $content_class = 'twwf_vertical';
}
$field_uid = uniqid('twwf_color_list');
?>

<?php if (isset($options)) { ?>
    <div class="tww_filter_field_block">
        <div class="twwf_field_header">
            <span class="tww_filter_field_title"><?php echo esc_html($field->name); ?></span>
            <span data-field_id="<?php echo esc_attr($field_uid); ?>" class="twwf_open_close_field"></span>
        </div>
        <div id="<?php echo esc_attr($field_uid); ?>" class="twwf_color_list <?php echo  esc_attr($content_class); ?>">
            <?php foreach ($options as $option) { ?>
                <?php
                $name = ($view_type === 'color_with_text') ? '<span class="tww_color_name">' . esc_html($option->name) . '</span>' : '';
                $checked = '';
                $u_id = uniqid($option->slug);
                $label_class = 'twwf_color_checkbox_label_' . esc_attr($option->item_id) . '_' . $field->id . ' .tww_color_input_flag';

                if ($option->checked) {
                    $checked = 'checked';
                }
                ?>
                <input style="display: none;" class="twwf_color_checkbox" <?php echo esc_attr($checked); ?> name="<?php echo esc_attr($field->inputName); ?>" id="<?php echo esc_attr($u_id); ?>" type="checkbox" value="<?php echo esc_attr($option->item_id); ?>">
                <label class="twwf_color_checkbox_label <?php echo esc_attr($label_class); ?>" for="<?php echo esc_attr($u_id); ?>"><?php echo $name; //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                    <span class="tww_color_input_flag"></span>
                </label>
                <?php
                    $color_style .= ' .' . $label_class . '{background-color:' . $option->color . ';}';
                ?>
            <?php }?>
            <style>
                <?php echo esc_attr($color_style); ?>
            </style>
        </div>
    </div>

<?php }?>