<?php
        $field = $context['field'];

        if (isset($field->options)) {
            $options = $field->options;
        }
        $field_uid = uniqid('twwf_checkbox');
?>

<?php if (isset($options)) { ?>
    <div class="tww_filter_field_block">
    <div class="twwf_field_header">
         <span class="tww_filter_field_title"><?php echo esc_html($field->name); ?></span>
         <span data-field_id="<?php echo esc_attr($field_uid); ?>" class="twwf_open_close_field"></span>
    </div>
     <div id="<?php echo esc_attr($field_uid); ?>" class="twwf_checkbox_list">
        <?php foreach ($options as $option) { ?>
            <?php
                if (isset($option->fieldState) && $option->fieldState === 'off') {
                    continue;
                }
                $checked = '';
                $u_id = $option->name . '_' . $option->item_id . '_' . $field->id;

                if (isset($option->checked) && $option->checked) {
                    $checked = 'checked';
                }
            ?>
            <label class="twwf_checkbox_item container" for="<?php echo esc_attr($u_id); ?>">
                <input <?php echo esc_attr($checked); ?> name="<?php echo esc_attr($field->inputName); ?>" id="<?php echo esc_attr($u_id); ?>" type="checkbox" value="<?php echo esc_attr($option->item_id); ?>">
                <span class="checkmark"></span>
                <span><?php echo esc_html($option->name); ?></span>
            </label>

        <?php }?>
     </div>
    </div>
<?php }?>
