<?php
$field = $context['field'];

if (isset($field->options)) {
    $options = $field->options;
}
$field_uid = uniqid('twwf_box');
?>

<?php if (isset($options)) { ?>
    <div class="tww_filter_field_block">
        <div class="twwf_field_header">
            <span class="tww_filter_field_title"><?php echo esc_html($field->name); ?></span>
            <span data-field_id="<?php echo esc_attr($field_uid); ?>" class="twwf_open_close_field"></span>
        </div>
        <div id="<?php echo esc_attr($field_uid); ?>" class="tww_box_item_container">
        <?php foreach ($options as $option) { ?>
            <?php
            if (isset($option->fieldState) && $option->fieldState === 'off') {
                continue;
            }
            $checked = '';
            $u_id = $option->name . '_' . $option->item_id . '_' . $field->id;

            if (isset($option->checked) && $option->checked) {
                $checked = 'checked';
            }
            ?>

            <div class="tww_box_item">
                <input <?php echo esc_attr($checked); ?> value="<?php echo esc_attr($option->item_id); ?>" name="<?php echo esc_attr($field->inputName); ?>" type="checkbox" class="tww_box_checkbox" id="<?php echo esc_attr($u_id); ?>" />
                <label class="tww_box_checkbox_label" for="<?php echo esc_attr($u_id); ?>"><?php echo esc_html($option->name); ?></label>
            </div>
        <?php }?>
        </div>



    </div>
<?php }?>
