<?php

namespace TenWebWooP\WoocommerceWidgets\Filter\Includes;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;
use Tenweb_Builder\Classes\Woocommerce\Woocommerce;
use TenWebWooP\WoocommerceWidgets\Filter\Includes\Filter\FilterBuilder;
use TenWebWooP\WoocommerceWidgets\Filter\Includes\Query\QueryBuilder;

class ElementorWidget extends \Elementor\Widget_Base {

    private $filter;

    public function get_name() {
        return 'tenweb-woo-filter';
    }

    public function get_title() {
        return 'Filter';
    }

    public function get_icon() {
        return 'twbb-widget-icon twbb-filtera';
    }

    public function get_categories() {
        return array( Woocommerce::WOOCOMMERCE_GROUP );
    }

    /**
     * Register widget controls.
     */
    public function register_controls() {
        $filters = \TenWebWooP\WoocommerceWidgets\Filter\Includes\Helper::getFilters();
        $filter_control_options = array();
        $tww_post_type_url = add_query_arg(array('post_type' => 'tww_filter'), admin_url() . 'edit.php');
        $default_filter = '';

        if (is_array($filters)) {
            foreach ($filters as $filter) {
                if (isset($filter->post_title, $filter->ID)) {
                    if (empty($default_filter)) {
                        $default_filter = $filter->ID;
                    }
                    $filter_control_options[$filter->ID] = $filter->post_title;
                }
            }
        }
        $url = add_query_arg(array('action' => 'tww_get_popup', 'elementor_callback' => 1, 'TB_iframe' => '1', 'width' => 600, 'height' => 700), admin_url('admin-ajax.php'));
        $this->start_controls_section(
            'tww_general',
            array(
                'label' => __('General', 'tww-filter'),
            )
        );

        $this->add_control(
            'tww_control_new_filter',
            array(
                'label' => '<span data-src="' . $url . '" class="tww_open_filter_popup_label">Add new filter</span>',
                'type' => \Elementor\Controls_Manager::BUTTON,
                'button_type' => 'default',
                'text' => 'New filter',
                'classes' => 'tww_open_filter_popup_button',
                'description' => ''
            )
        );
        $this->add_control(
            'tww_control_filter',
            array(
                'label' => 'Select filter <span class="tww_elementor_edit_filter">Edit filter</span>',
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $filter_control_options,
                'description' => '',
                'classes' => 'tww_control_filter',
                'default' => $default_filter
            )
        );
        $this->add_control(
            'tww_filter_button_text',
            array(
                'label' => 'Filter button text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'classes' => '',
                'description' => '',
                'input_type' => 'text',
                'classes' => 'tww_filter_button_text',
                'default' => 'Filter'
            )
        );
        $this->add_control(
            'tww_reset_button_text',
            array(
                'label' => 'Reset button text',
                'type' => \Elementor\Controls_Manager::TEXT,
                'text' => 'Reset',
                'classes' => '',
                'description' => '',
                'input_type' => 'text',
                'default' => 'Reset'
            )
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_a',
            array(
                'label' => '',
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name' => 'filter_field_title_typography',
                'label' => 'Field title',
                'global' => array(
                    'default' => Global_Typography::TYPOGRAPHY_TEXT,
                ),
                'selector' => '{{WRAPPER}} .tww_filter_field_title',
            )
        );
        $this->add_control(
            'filter_title_color',
            array(
                'label' => 'Field title color',
                'type' => Controls_Manager::COLOR,

                'selectors' => array(
                    '{{WRAPPER}} .tww_filter_field_title' => 'color: {{VALUE}}',
                ),
                'global' => array(
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ),
            )
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name' => 'filter_field_el_typography',
                'label' => 'Field name',
                'global' => array(
                    'default' => Global_Typography::TYPOGRAPHY_TEXT,
                ),
                'selector' => '{{WRAPPER}} .tww_filter_form .twwf_filter_form_fields label',
            )
        );
        $this->add_control(
            'filter_text_color',
            array(
                'label' => 'Field name color',
                'type' => Controls_Manager::COLOR,

                'selectors' => array(
                    '{{WRAPPER}} .tww_filter_form .twwf_filter_form_fields label, .tww_filter_form .tww_filter_field_block .twwf_price_slider_container .ui-slider-handle .tww_handle_price, .tww_filter_form .tww_price_item, .tww_filter_form .select2-container--default .select2-selection--single .select2-selection__rendered' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .tww_filter_form .tww_box_checkbox_label' => 'border-color: {{VALUE}}',
                ),
                'global' => array(
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
                ),
            )
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name' => 'button_text_typography',
                'label' => 'Button text',
                'global' => array(
                    'default' => Global_Typography::TYPOGRAPHY_ACCENT,
                ),
                'selector' => '{{WRAPPER}} .tww_filter_form .twwf_filter_actions .twwf_submit, .tww_filter_form .twwf_filter_actions .twwf_reset_filter',
            )
        );
        $this->add_control(
            'filter_buttons_color',
            array(
                'label' => 'Button color',
                'type' => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .tww_filter_form .twwf_filter_actions .twwf_submit' => 'color: {{VALUE}}',
                ),
                'global' => array(
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_SECONDARY,
                ),
            )
        );
        $this->add_control(
            'filter_button_background_color',
            array(
                'label' => 'Button background color',
                'type' => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .tww_filter_form .twwf_filter_actions .twwf_submit' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .tww_box_checkbox:checked + .tww_box_checkbox_label' => 'background: {{VALUE}} 0% 0% no-repeat padding-box;',
                    '{{WRAPPER}} .tww_filter_form .twwf_filter_actions .twwf_reset_filter' => 'color: {{VALUE}}',
                ),
                'global' => array(
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
                ),
            )
        );
        $this->add_control(
            'filter_button_border_color',
            array(
                'label' => 'Button border color',
                'type' => Controls_Manager::COLOR,
                'selectors' => array(
                    '{{WRAPPER}} .tww_filter_form .twwf_filter_actions .twwf_submit' => 'border-color: {{VALUE}}',
                ),
                'global' => array(
                    'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
                ),
            )
        );
        $this->end_controls_section();
    }

    public function get_script_depends() {
        return array( 'jquery_ui-script', 'tww_select2-script', 'tww_filter-script' );
    }

    public function get_style_depends() {
        return array( 'tww_select2-style', 'tww_filter-style', 'jquery_ui-style' );
    }

    public function render() {
        $settings = $this->get_settings_for_display();

        if (!empty($settings['tww_control_filter'])) {
            $filter_id = $settings['tww_control_filter'];
            $filterBuilder = new FilterBuilder($filter_id);
            $this->filter = $filterBuilder->getFilter();
            $filterBuilder->renderFilter($settings);
            add_filter('woocommerce_shortcode_products_query', array($this, 'shortcodeProductsQuery'), 10, 3);
            add_filter('twb_shortcode_products_query', array($this, 'shortcodeProductsQuery'), 10, 3);
        }
    }

    public function shortcodeProductsQuery($query_args, $atts, $loop_name) {
        $queryBuilder = new QueryBuilder($this->filter, $query_args);

        return $queryBuilder->get();
    }
}
