<?php

namespace TenWebWooP\PaymentMethods;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use TenWebWooP\Config;

class TenWebPaymentsBlock extends AbstractPaymentMethodType {

    public function initialize() {
        $this->name = 'tenweb_payments';
        $this->settings = get_option('woocommerce_tenweb_payments_settings', array());
        $this->mode = isset($this->settings['test_mode']) && $this->settings['test_mode'] === 'no' ? 'live' : 'test';
        $this->merchant = Config::get_payengine_data($this->mode);
        add_action('woocommerce_rest_checkout_process_payment_with_context', array( $this, 'process_payment' ), 11, 2);
    }

    public function is_active() {
        return ! empty($this->settings['enabled']) && 'yes' === $this->settings['enabled'];
    }

    // I don't really understand why this function is required to be declared as it is passed to the old one.
    // But it does not work without this line.
    public function process_payment($context, &$result) {
    }

    public function get_payment_method_script_handles() {
        wp_enqueue_style('twwp_payment_method_style', Config::get_url('PaymentMethods', '/assets/style.css'), array(), Config::VERSION);
        wp_register_script('twwp_payengine', $this->merchant['script_url'], array( 'jquery' ), null, false);
        wp_register_script('twwp_script', Config::get_url('PaymentMethods', 'assets/script.js'), array('jquery'), Config::VERSION);
        wp_register_script('twwp_block_editor_script', Config::get_url('PaymentMethods', '/assets/build/block-compiled.js'), array('react', 'react-dom', 'wc-blocks-registry', 'wp-dom-ready', 'wp-element', 'wp-i18n', 'wp-polyfill', 'twwp_payengine', 'twwp_script'), Config::VERSION, true);
        wp_localize_script(
            'twwp_script',
            'twwp_config',
            array(
                'merchant_id' => $this->merchant['merchant_id'],
            )
        );

        return array('twwp_block_editor_script');
    }

    public function get_payment_method_script_handles_for_admin() {
        return $this->get_payment_method_script_handles();
    }

    public function get_payment_method_data() {
        // Access to this in frontend like wc.wcSettings.getSetting( 'tenweb_payments_data' )
        return array('test_mode' => $this->get_setting('test_mode'));
    }
}
