<?php

namespace TenWebWooP\PaymentMethods;

use TenWebWooP\CheckAuthorization;
use TenWebWooP\Config;
use TenWebWooP\Utils;
use WP_REST_Request;
use WP_REST_Server;

class Api {

    use CheckAuthorization;

    public function register_routes() {
        register_rest_route(
            'tenweb_woop/v1',
            'payment_methods/payengine/merchant',
            array(
                'methods' => WP_REST_Server::CREATABLE,
                'callback' => array($this, 'update_merchant' ),
                'permission_callback' => array($this, 'check_authorization'),
            )
        );
    }

    public function update_merchant(WP_REST_Request $request) {
        $data = json_decode($request->get_body());
        // TODO: validate this before save
        update_option(Config::PREFIX . '_payengine_data', $data);

        $merchant_test = Config::get_payengine_data('test');
        $merchant_live = Config::get_payengine_data('live');

        // Enable appropriate mode if only one merchant is added.
        $mode = false;

        if ($merchant_test['merchant_id'] && !$merchant_live['merchant_id']) {
            $mode = 'yes';
        } elseif (!$merchant_test['merchant_id'] && $merchant_live['merchant_id']) {
            $mode = 'no';
        }

        if ($mode) {
            Utils::updateTenwebPayengineTestMode($mode);
        }

        return array(
            'msg' => 'success',
            'status' => 200,
        );
    }
}
