<?php

namespace TenWebWooP;

use TenWebWooP\WoocommerceWidgets\Filter\WoocommerceProductFilters;

class Init {

    private static $instance = null;

    private function __construct() {
        /*Check if WooCommerce is activated*/
        if (class_exists('woocommerce')) {
            $this->init();

            if (defined('TWBB_VERSION')) {
                $this->registerWidgets();
            }
        }
    }

    /**
     * @return Init|null
     */
    public static function getInstance() {
        if (self::$instance === null) {
            return new self();
        }

        return self::$instance;
    }

    public static function initBasicActions() {
        if (class_exists('woocommerce')) {
            Settings::trackIfOptionUpdated('woocommerce_default_country');
        }
    }

    private function init() {
        $Authorization = new Authorization();
        $Authorization->init();
        new Api();

        if (defined('TWM_ENABLE_PAYMENT') && TWM_ENABLE_PAYMENT) {
            PaymentMethods\TenWebPayments::get_instance()->register_payment_method();
        }
        // Hide Woocommerce Marketplace Suggestions and Setup Wizard
        add_filter('woocommerce_allow_marketplace_suggestions', '__return_false');

        if (!get_option('woocommerce_onboarding_profile')) {
            add_option('woocommerce_onboarding_profile', array('skipped' => true));
        }

        if (!get_option('woocommerce_show_marketplace_suggestions')) {
            add_option('woocommerce_show_marketplace_suggestions', 'no');
        }
        // Hide Payment Method tasks in WooCommerce Onboarding
        add_filter('woocommerce_admin_features', function ($features) {
            $features = array_diff($features, array('payment-gateway-suggestions'));

            return $features;
        });
        // Hide Payment Method suggestions in WooCommerce Settings Payments tab
        if (!get_option('woocommerce_setting_payments_recommendations_hidden')) {
            add_option('woocommerce_setting_payments_recommendations_hidden', 'yes');
        }
        // This will remove WooPayments from suggestions and rename the list title
        add_filter('woocommerce_admin_payment_gateway_suggestion_specs', function ($payment_gateways) {
            $payment_gateways = array(
                array(
                    'id' => 'tenweb_payments',
                ),
            );

            return $payment_gateways;
        });
    }

    private function registerWidgets() {
        if (!defined('TWM_DISABLE_WOOCOMMERCE_PRODUCT_FILTER') || !TWM_DISABLE_WOOCOMMERCE_PRODUCT_FILTER) {
            WoocommerceProductFilters::getInstance();
        }
    }
}
